define("core/local/templates/renderer",["exports","core/log","core/truncate","core/user_date","core/pending","core/str","core/icon_system","core/config","core/mustache","./loader","core/utils"],(function(_exports,Log,Truncate,UserDate,_pending,_str,_icon_system,_config,_mustache,_loader,_utils){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,Log=_interopRequireWildcard(Log),Truncate=_interopRequireWildcard(Truncate),UserDate=_interopRequireWildcard(UserDate),_pending=_interopRequireDefault(_pending),_icon_system=_interopRequireDefault(_icon_system),_config=_interopRequireDefault(_config),_mustache=_interopRequireDefault(_mustache),_loader=_interopRequireDefault(_loader);
/**
   * Template Renderer Class.
   *
   * Note: This class is not intended to be instantiated directly. Instead, use the core/templates module.
   *
   * @module     core/local/templates/renderer
   * @copyright  2023 Andrew Lyons <andrew@nicols.co.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @since      4.3
   */
class Renderer{constructor(){_defineProperty(this,"requiredStrings",null),_defineProperty(this,"requiredDates",[]),_defineProperty(this,"requiredJS",null),_defineProperty(this,"currentThemeName",""),_defineProperty(this,"iconSystem",null),this.requiredStrings=[],this.requiredJS=[],this.requiredDates=[],this.currentThemeName=""}static setLoader(loader){this.loader=loader}static getLoader(){return this.loader}async renderIcon(key,component,title){component=(0,_utils.getNormalisedComponent)(component),await this.setupIconSystem();const template=await Renderer.getLoader().getTemplate(this.iconSystem.getTemplateName(),this.currentThemeName);return this.iconSystem.renderIcon(key,component,title,template)}async setupIconSystem(){return this.iconSystem||(this.iconSystem=await _icon_system.default.instance()),this.iconSystem}pixHelper(context,sectionText,helper){const parts=sectionText.split(",");let key="",component="",text="";parts.length>0&&(key=helper(parts.shift().trim(),context)),parts.length>0&&(component=helper(parts.shift().trim(),context)),parts.length>0&&(text=helper(parts.join(",").trim(),context));const Loader=Renderer.getLoader(),templateName=this.iconSystem.getTemplateName(),searchKey=Loader.getSearchKey(this.currentThemeName,templateName),template=Loader.getTemplateFromCache(searchKey);return component=(0,_utils.getNormalisedComponent)(component),key=key.replace(/&#x2F;/gi,"/"),this.iconSystem.renderIcon(key,component,text,template)}jsHelper(context,sectionText,helper){return this.requiredJS.push(helper(sectionText,context)),""}stringHelper(context,sectionText,helper){let parts=sectionText.split(",");const key=parts.length>0?parts.shift().trim():"",component=parts.length>0?(0,_utils.getNormalisedComponent)(parts.shift().trim()):"";let param=parts.length>0?parts.join(",").trim():"";if(""!==param&&(param=helper(param,context)),param.match(/^{\s*"/gm))try{const parsedParam=JSON.parse(param);parsedParam&&"object"==typeof parsedParam&&(param=parsedParam)}catch(err){window.console.warn(err.message)}const index=this.requiredStrings.length;return this.requiredStrings.push({key:key,component:component,param:param}),"[[_s".concat(index,"]]")}cleanStringHelper(context,sectionText,helper){return this.stringHelper(context,sectionText,helper).replace("s","c")}quoteHelper(context,sectionText,helper){let content=helper(sectionText.trim(),context);return content=JSON.stringify(content),content=content.replace(/([{}]{2,3})/g,"{{=<% %>=}}$1<%={{ }}=%>"),content}shortenTextHelper(context,sectionText,helper){const parts=sectionText.match(/(.*?),(.*)/),length=parts[1].trim(),content=helper(parts[2].trim(),context);return Truncate.truncate(content,{length:length,words:!0,ellipsis:"..."})}userDateHelper(context,sectionText,helper){const parts=sectionText.match(/(.*?),(.*)/),timestamp=helper(parts[1].trim(),context),format=helper(parts[2].trim(),context),index=this.requiredDates.length;return this.requiredDates.push({timestamp:timestamp,format:format}),"[[_t_".concat(index,"]]")}addHelperFunction(helperFunction,context){return function(){return function(sectionText,helper){const originalHelpers=Renderer.disallowedNestedHelpers.reduce(((carry,name)=>(context.hasOwnProperty(name)&&(carry[name]=context[name]),carry)),{});Renderer.disallowedNestedHelpers.forEach((helperName=>{context[helperName]=()=>""}));const result=helperFunction.apply(this,[context,sectionText,helper]);for(const name in originalHelpers)context[name]=originalHelpers[name];return result}.bind(this)}.bind(this)}addHelpers(context,themeName){this.currentThemeName=themeName,this.requiredStrings=[],this.requiredJS=[],context.uniqid=Renderer.uniqInstances++,context.str=this.addHelperFunction(this.stringHelper,context),context.cleanstr=this.addHelperFunction(this.cleanStringHelper,context),context.pix=this.addHelperFunction(this.pixHelper,context),context.js=this.addHelperFunction(this.jsHelper,context),context.quote=this.addHelperFunction(this.quoteHelper,context),context.shortentext=this.addHelperFunction(this.shortenTextHelper,context),context.userdate=this.addHelperFunction(this.userDateHelper,context),context.globals={config:_config.default},context.currentTheme=themeName}getJS(){return this.requiredJS.join(";\n")}treatStringsInContent(content,stringMap){const stringPattern=/(?<placeholder>\[\[_(?<stringType>[cs])(?<stringIndex>\d+)\]\])/g,getUpdatedString=_ref=>{let{placeholder:placeholder,stringType:stringType,stringIndex:stringIndex}=_ref;if(stringMap.has(placeholder))return stringMap.get(placeholder);if("c"===stringType){const uncleanString=stringMap.get("[[_s".concat(stringIndex,"]]"));if(uncleanString)return stringMap.set(placeholder,_mustache.default.escape(uncleanString)),stringMap.get(placeholder)}return Log.debug("Could not find string for pattern ".concat(placeholder)),""};let match;for(;null!==(match=stringPattern.exec(content));){let updatedContent=content.slice(0,match.index);updatedContent+=getUpdatedString(match.groups),updatedContent+=content.slice(match.index+match.groups.placeholder.length),content=updatedContent}return content}treatDatesInContent(content,dates){return dates.forEach(((date,index)=>{content=content.replace(new RegExp("\\[\\[_t_".concat(index,"\\]\\]"),"g"),date)})),content}async doRender(templateSourcePromise,context,themeName){this.currentThemeName=themeName;const iconTemplate=this.iconSystem.getTemplateName(),pendingPromise=new _pending.default("core/templates:doRender"),[templateSource]=await Promise.all([templateSourcePromise,Renderer.getLoader().getTemplate(iconTemplate,themeName)]),templateContext={...context};this.addHelpers(templateContext,themeName);const renderedContent=await _mustache.default.render(templateSource,templateContext,(partialName=>Renderer.getLoader().partialHelper(partialName,themeName))),{html:html,js:js}=await this.processRenderedContent(renderedContent);return pendingPromise.resolve(),{html:html,js:js}}async processRenderedContent(renderedContent){let html=renderedContent.trim(),js=this.getJS();if(this.requiredStrings.length>0){const stringMap=new Map((await(0,_str.getStrings)(this.requiredStrings)).map(((string,index)=>["[[_s".concat(index,"]]"),string])));this.requiredDates=this.requiredDates.map(function(date){return{timestamp:this.treatStringsInContent(date.timestamp,stringMap),format:this.treatStringsInContent(date.format,stringMap)}}.bind(this)),html=this.treatStringsInContent(html,stringMap),js=this.treatStringsInContent(js,stringMap)}if(this.requiredDates.length>0){const dates=await UserDate.get(this.requiredDates);html=this.treatDatesInContent(html,dates),js=this.treatDatesInContent(js,dates)}return{html:html,js:js}}async render(templateName){let context=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},themeName=arguments.length>2&&void 0!==arguments[2]?arguments[2]:_config.default.theme;this.currentThemeName=themeName,await this.setupIconSystem();const templateSource=Renderer.getLoader().cachePartials(templateName,themeName);return this.doRender(templateSource,context,themeName)}}return _exports.default=Renderer,_defineProperty(Renderer,"uniqInstances",0),_defineProperty(Renderer,"loadTemplateBuffer",[]),_defineProperty(Renderer,"isLoadingTemplates",!1),_defineProperty(Renderer,"disallowedNestedHelpers",["js"]),_defineProperty(Renderer,"templateCache",{}),_defineProperty(Renderer,"templatePromises",{}),_defineProperty(Renderer,"loader",_loader.default),_exports.default}));

//# sourceMappingURL=renderer.min.js.map