<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_remui
 * @copyright (c) 2023 WisdmLabs (https://wisdmlabs.com/) <support@wisdmlabs.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Erweiterte Einstellungen';
$string['backgroundimage'] = 'Hintergrundbild';
$string['backgroundimage_desc'] = 'Das Bild, das als Hintergrund der Seite angezeigt werden soll. Das hier hochgeladene Hintergrundbild überschreibt das Hintergrundbild in den voreingestellten Theme-Dateien.';
$string['brandcolor'] = 'Markenfarbe';
$string['brandcolor_desc'] = 'Die Markenfarbe.';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'Ein Bootswatch ist eine Sammlung von Bootstrap-Variablen und CSS zur Gestaltung von Bootstrap.';
$string['choosereadme'] = 'Edwiser RemUI ein modernes und hochgradig anpassbares Theme. Dieses Theme ist zur direkten Verwendung oder als Eltern-Theme gedacht, wenn neue Themes erstellt werden, die Bootstrap 4 verwenden.';
$string['currentinparentheses'] = '(aktuell)';
$string['configtitle'] = 'Edwiser RemUI';
$string['generalsettings'] = 'grundlegend';
$string['loginbackgroundimage'] = 'Hintergrundbild der Anmeldeseite';
$string['loginbackgroundimage_desc'] = 'Das Bild, das als Hintergrund für die Anmeldeseite angezeigt werden soll.';
$string['nobootswatch'] = 'Kein Bootswatch';
$string['pluginname'] = 'Edwiser RemUI';
$string['presetfiles'] = 'Zusätzliche Theme-Voreinstellungsdateien';
$string['presetfiles_desc'] = 'Preset files can be used to dramatically alter the appearance of the theme. See <a href="https://docs.moodle.org/dev/remui_Presets">remui presets</a> for information on creating and sharing your own preset files, and see the <a href="https://archive.moodle.net/remui">Presets repository</a> for presets that others have shared.';
$string['preset'] = 'Theme preset';
$string['presetfiles_desc'] = 'Vorlagendateien können verwendet werden, um das Erscheinungsbild des Themas dramatisch zu verändern. Siehe <a href="https://docs.moodle.org/dev/remui_Presets">remui Vorlagen</a> für Informationen zum Erstellen und Teilen eigener Vorlagendateien und siehe das <a href="https://archive.moodle.net/remui">Vorlagen-Repository</a> für Vorlagen, die andere geteilt haben.';
$string['preset'] = 'Thema-Vorlage';
$string['preset_desc'] = 'Wählen Sie eine Vorlage, um das Aussehen des Themas grundlegend zu ändern.';
$string['privacy:metadata'] = 'Das Remui-Theme speichert keine personenbezogenen Daten über Benutzer.';
$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Verwenden Sie dieses Feld, um SCSS- oder CSS-Code bereitzustellen, der am Ende des Stylesheets eingefügt wird.';
$string['rawscsspre'] = 'Raw Anfangs-SCSS';
$string['rawscsspre_desc'] = 'In diesem Feld können Sie initialisierenden SCSS-Code bereitstellen, der vor allem anderen eingefügt wird. In der Regel verwenden Sie diese Einstellung, um Variablen zu definieren.';
$string['region-side-pre'] = 'Rechts';
$string['region-side-top'] = 'Oben';
$string['region-side-bottom'] = 'Unten';
$string['showfooter'] = 'Fußzeile anzeigen';
$string['unaddableblocks'] = 'Überflüssige Blöcke';
$string['unaddableblocks_desc'] = 'Die angegebenen Blöcke sind bei Verwendung dieses Themes nicht erforderlich und werden im Menü "Block hinzufügen" nicht aufgelistet.';
$string['privacy:metadata:preference:draweropenblock'] = 'Die Einstellung des Benutzers zum Ausblenden oder Anzeigen des Schubladens mit Blöcken.';
$string['privacy:metadata:preference:draweropenindex'] = 'Die Einstellung des Benutzers zum Ausblenden oder Anzeigen des Schubladens mit Kursindex.';
$string['privacy:metadata:preference:draweropennav'] = 'Die Einstellung des Benutzers zum Ausblenden oder Anzeigen der Schubladenmenü-Navigation.';
$string['privacy:drawerindexclosed'] = 'Die aktuelle Einstellung für den Index-Schubladen ist geschlossen.';
$string['privacy:drawerindexopen'] = 'Die aktuelle Einstellung für den Index-Schubladen ist geöffnet.';
$string['privacy:drawerblockclosed'] = 'Die aktuelle Einstellung für die Block-Schubladen ist geschlossen.';
$string['privacy:drawerblockopen'] = 'Die aktuelle Einstellung für die Block-Schubladen ist geöffnet.';
$string['privacy:drawernavclosed'] = 'Die aktuelle Einstellung für die Navigations-Schublade ist geschlossen.';
$string['privacy:drawernavopen'] = 'Die aktuelle Einstellung für die Navigations-Schublade ist geöffnet.';

// Deprecated since Moodle 4.0.
$string['totop'] = 'Zum Anfang';

// Edwiser RemUI Settings Page Strings.

// Settings Tabs strings.
$string['homepagesettings'] = 'Startseite';
$string['coursesettings'] = "Kursseite";
$string['footersettings'] = 'Fußzeile';
$string["formsettings"] = "Formulare";
$string["iconsettings"] = "Symbole";
$string['loginsettings'] = 'Anmeldeseite';

$string['versionforheading'] = '<span class="small remuiversion"> Version {$a}</span>';
$string['themeversionforinfo'] = '<span>Installierte Version: Edwiser RemUI v{$a}</span>';

// General Settings.
$string['mergemessagingsidebar'] = 'Nachrichten-Panel zusammenführen';
$string['mergemessagingsidebardesc'] = 'Das Nachrichten-Panel in die rechte Seitenleiste integrieren';
$string['logoorsitename'] = 'Logofomat auswählen';
$string['logoorsitenamedesc'] = 'Nur Logo - Großes Brand-Logo<br /> Mini-Logo - Mini-Brand-Logo <br /> Nur Symbol - Ein Symbol als Marke <br/> Symbol und Sitename - Symbol mit Sitename';
$string['onlylogo'] = 'Nur Logo';
$string['logo'] = 'Logo';
$string['logomini'] = 'Mini-Logo';
$string['icononly'] = 'Nur Symbol';
$string['iconsitename'] = 'Symbol und Sitename';
$string['logodesc'] = 'Hier können Sie das Logo einfügen, das im Header angezeigt wird. Hinweis: Die bevorzugte Höhe beträgt 50px. Wenn Sie es anpassen möchten, können Sie dies im benutzerdefinierten CSS-Feld tun.';
$string['logominidesc'] = 'Hier können Sie das Mini-Logo einfügen, das im Header angezeigt wird, wenn die Seitenleiste ausgeblendet ist. Hinweis: Die bevorzugte Höhe beträgt 50px. Wenn Sie es anpassen möchten, können Sie dies im benutzerdefinierten CSS-Feld tun.';
$string['siteicon'] = 'Seiten-Symbol';
$string['siteicondesc'] = 'Kein Logo? Sie können eines aus dieser <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new" ><b style="color:#17a2b8!important">Liste</b></a> auswählen. <br /> Geben Sie einfach den Text nach "fa-" ein.';
$string['navlogin_popup'] = 'Anmelde-Popup aktivieren';
$string['navlogin_popupdesc'] = 'Aktivieren Sie das Anmelde-Popup, um sich schnell anzumelden, ohne zur Anmeldeseite weitergeleitet zu werden.';
$string['coursecategories'] = 'Kategorien';
$string['enablecoursecategorymenu'] = "Kategorie-Dropdown im Header anzeigen";
$string['enablecoursecategorymenudesc'] = "Halten Sie diese Option aktiviert, wenn Sie das Kategorie-Dropdown-Menü im Header anzeigen möchten.";
$string['coursepagesettings'] = "Kursseite";
$string['coursepagesettingsdesc'] = "Einstellungen im Zusammenhang mit Kursen.";
$string['coursecategoriestext'] = "Kategorie-Dropdown im Header umbenennen";
$string['coursecategoriestextdesc'] = "Sie können einen benutzerdefinierten Namen für das Kategorie-Dropdown-Menü im Header hinzufügen.";
$string['enablerecentcourses'] = 'Neueste Kurse aktivieren';
$string['enablerecentcoursesdesc'] = 'Wenn aktiviert, wird das Dropdown-Menü für die neuesten Kurse im Header angezeigt.';
$string['recent'] = 'Neueste';
$string['recentcoursesmenu'] = 'Menü für neueste Kurse';
$string['searchcatplaceholdertext'] = 'Kategorien suchen';
$string['viewallnotifications'] = 'Alle Benachrichtigungen anzeigen';
$string['forgotpassword'] = 'Passwort vergessen?';
$string['enableannouncement'] = "Site-weite Ankündigung aktivieren";
$string['enableannouncementdesc'] = "Aktivieren Sie site-weite Ankündigungen für alle Benutzer.";
$string['enabledismissannouncement'] = "Dismissable Site-weite Ankündigung aktivieren";
$string['enabledismissannouncementdesc'] = "Wenn aktiviert, können Benutzer die Ankündigung ausblenden.";
$string['brandlogo'] = 'Markenlogo';
$string['brandname'] = 'Markenname';

$string['announcementtext'] = "Ankündigung";
$string['announcementtextdesc'] = "Ankündigungstext, der siteweit angezeigt werden soll.";
$string['announcementtype'] = "Art der Ankündigung";
$string['announcementtypedesc'] = "Wählen Sie die Art der Ankündigung, um eine unterschiedliche Hintergrundfarbe für die Ankündigung anzuzeigen.";
$string['typeinfo'] = "Information";
$string['typedanger'] = "Dringend";
$string['typewarning'] = "Warnung";
$string['typesuccess'] = "Erfolg";

// Google Analytics.
$string['googleanalytics'] = 'Google Analytics Tracking ID';
$string['googleanalyticsdesc'] = 'Bitte geben Sie Ihre Google Analytics Tracking ID ein, um Analytics auf Ihrer Website zu aktivieren. Das Tracking ID-Format sollte wie folgt aussehen: [UA-XXXXX-Y].<br/>Bitte beachten Sie, dass Sie durch das Hinzufügen dieser Einstellung Daten an Google Analytics senden. Stellen Sie sicher, dass Ihre Benutzer darüber informiert sind. Unser Produkt speichert keine der an Google Analytics gesendeten Daten.';
$string['favicon'] = 'Favicon';
$string['favicosize'] = 'Erwartete Größe beträgt 16x16 Pixel';
$string['favicondesc'] = 'Das "Favoriten"-Symbol Ihrer Website. Es erinnert visuell an die Identität der Website und wird in der Adressleiste oder in den Registerkarten des Browsers angezeigt.';
$string['fontselect'] = 'Schriftarten-Auswahl';
$string['fontselectdesc'] = 'Wählen Sie zwischen Standard-Schriftarten oder <a href="https://fonts.google.com/" target="_new">Google-Web-Schriftarten</a>. Bitte speichern Sie, um die Optionen für Ihre Auswahl anzuzeigen. Hinweis: Wenn die Benutzerdefinierte Schriftart auf Standard eingestellt ist, wird die Google Web-Schriftart angewendet.';
$string['fontname'] = 'Website-Schriftart';
$string['fontnamedesc'] = 'Geben Sie den genauen Namen der Schriftart ein, die für Moodle verwendet werden soll.';
$string['fonttypestandard'] = 'Standard-Schriftart';
$string['fonttypegoogle'] = 'Google-Web-Schriftart';

$string['sendfeedback'] = "Feedback an Edwiser senden";
$string['enableedwfeedback'] = "Edwiser Feedback & Support aktivieren";
$string['enableedwfeedbackdesc'] = "Aktivieren Sie das Edwiser Feedback & Support, das nur für Admins sichtbar ist.";
$string["checkfaq"] = "Edwiser RemUI - FAQ überprüfen";
$string['poweredbyedwiser'] = 'Powered by Edwiser';
$string['poweredbyedwiserdesc'] = 'Deaktivieren Sie das Kontrollkästchen, um \'Powered by Edwiser\' von Ihrer Website zu entfernen.';
$string['enabledictionary'] = 'Wörterbuch aktivieren';
$string['enabledictionarydesc'] = 'Wenn aktiviert, wird die Wörterbuchfunktion aktiviert und die Bedeutung des ausgewählten Textes in einem Popup angezeigt.';
$string['customcss'] = 'Benutzerdefiniertes CSS';
$string['customcssdesc'] = 'Sie können das CSS aus dem obenstehenden Textfeld anpassen. Die Änderungen werden auf allen Seiten Ihrer Website widerspiegelt.';

// Footer Content.
$string['followus'] = 'Folgen Sie uns';
$string['poweredby'] = 'Angetrieben von';

// One click report  bug/feedback.
$string['sendfeedback'] = "Feedback an Edwiser senden";
$string['descriptionmodal_text1'] = "<p>Mit Feedback können Sie uns Vorschläge zu unseren Produkten senden. Wir begrüßen Problemberichte, Funktionsideen und allgemeine Kommentare.</p><p>Beginnen Sie mit einer kurzen Beschreibung:</p>";
$string['descriptionmodal_text2'] = "<p>Anschließend lassen wir Sie Bereiche der Seite identifizieren, die sich auf Ihre Beschreibung beziehen.</p>";
$string['emptydescription_error'] = "Bitte geben Sie eine Beschreibung ein.";
$string['incorrectemail_error'] = "Bitte geben Sie eine gültige E-Mail-Adresse ein.";

$string['highlightmodal_text1'] = "Klicken und ziehen Sie auf der Seite, um uns dabei zu helfen, Ihr Feedback besser zu verstehen. Sie können dieses Dialogfeld verschieben, wenn es im Weg ist.";
$string['highlight_button'] = "Bereich hervorheben";
$string['blackout_button'] = "Info ausblenden";
$string['highlight_button_tooltip'] = "Bereiche hervorheben, die für Ihr Feedback relevant sind.";
$string['blackout_button_tooltip'] = "Persönliche Informationen ausblenden.";

$string['feedbackmodal_next'] = 'Screenshot erstellen und fortsetzen';
$string['feedbackmodal_skipnext'] = 'Überspringen und fortsetzen';
$string['feedbackmodal_previous'] = 'Zurück';
$string['feedbackmodal_submit'] = 'Absenden';
$string['feedbackmodal_ok'] = 'Okay';

$string['description_heading'] = 'Beschreibung';
$string['feedback_email_heading'] = 'E-Mail';
$string['additional_info'] = 'Zusätzliche Informationen';
$string['additional_info_none'] = 'Keine';
$string['additional_info_browser'] = 'Browser-Informationen';
$string['additional_info_page'] = 'Seiteninformationen';
$string['additional_info_pagestructure'] = 'Seitenstruktur';
$string['feedback_screenshot'] = 'Screenshot';
$string['feebdack_datacollected_desc'] = 'Eine Übersicht über die gesammelten Daten finden Sie <strong><a href="https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products" target="_blank">hier</a></strong>.';

$string['submit_loading'] = 'Ladevorgang läuft...';
$string['submit_success'] = 'Vielen Dank für Ihr Feedback. Wir schätzen jedes Feedback, das wir erhalten.';
$string['submit_error'] = 'Leider ist beim Senden Ihres Feedbacks ein Fehler aufgetreten. Bitte versuchen Sie es erneut.';
$string['send_feedback_license_error'] = "Bitte aktivieren Sie die Lizenz, um Produktsupport zu erhalten.";
$string['disabled'] = 'Deaktiviert';

$string['nocoursefound'] = 'Kein Kurs gefunden';

$string['pagewidth'] = 'Themenlayout';
$string['pagewidthdesc'] = 'Hier können Sie die Layoutgröße für Seiten auswählen.';
$string['defaultpermoodle'] = 'Schmale Breite (Moodle-Standard)';
$string['fullwidthlayout'] = 'Volle Breite';

// Footer Page Settings.
$string['footersettings'] = 'Footer';
$string['socialmedia'] = 'Soziale Medien';
$string['socialmediadesc'] = 'Geben Sie die Links zu den sozialen Medien für Ihre Website ein.';
$string['facebooksetting'] = 'Facebook';
$string['facebooksettingdesc'] = 'Geben Sie den Link zur Facebook-Seite Ihrer Website ein. Zum Beispiel: https://www.facebook.com/pagename';
$string['twittersetting'] = 'Twitter';
$string['twittersettingdesc'] = 'Geben Sie den Link zur Twitter-Seite Ihrer Website ein. Zum Beispiel: https://www.twitter.com/pagename';
$string['linkedinsetting'] = 'Linkedin';
$string['linkedinsettingdesc'] = 'Geben Sie den Link zur Linkedin-Seite Ihrer Website ein. Zum Beispiel: https://www.linkedin.com/in/pagename';
$string['gplussetting'] = 'Google Plus';
$string['gplussettingdesc'] = 'Geben Sie den Link zur Google Plus-Seite Ihrer Website ein. Zum Beispiel: https://plus.google.com/pagename';
$string['youtubesetting'] = 'YouTube';
$string['youtubesettingdesc'] = 'Geben Sie den Link zur YouTube-Seite Ihrer Website ein. Zum Beispiel: https://www.youtube.com/channel/UCU1u6QtAAPJrV0v0_c2EISA';
$string['instagramsetting'] = 'Instagram';
$string['instagramsettingdesc'] = 'Geben Sie den Link zur Instagram-Seite Ihrer Website ein. Zum Beispiel: https://www.instagram.com/name';
$string['pinterestsetting'] = 'Pinterest';
$string['pinterestsettingdesc'] = 'Geben Sie den Link zur Pinterest-Seite Ihrer Website ein. Zum Beispiel: https://www.pinterest.com/name';
$string['quorasetting'] = 'Quora';
$string['quorasettingdesc'] = 'Geben Sie den Link zur Quora-Seite Ihrer Website ein. Zum Beispiel: https://www.quora.com/name';
$string['footerbottomtext'] = 'Footer-Text unten links';
$string['footerbottomlink'] = 'Footer-Link unten links';
$string['footerbottomlinkdesc'] = 'Geben Sie den Link für den unteren linken Abschnitt des Footers ein. Zum Beispiel http://www.ihrefirma.com';
$string['footercolumn1heading'] = 'Inhalt des Footers für die 1. Spalte (links)';
$string['footercolumn1headingdesc'] = 'Dieser Abschnitt bezieht sich auf den unteren Teil (Spalte 1) Ihrer Startseite.';
$string['footercolumn1title'] = 'Titel der 1. Footer-Spalte';
$string['footercolumn1titledesc'] = 'Fügen Sie einen Titel zu dieser Spalte hinzu.';
$string['footercolumncustomhtml'] = 'Inhalt';
$string['footercolumn1customhtmldesc'] = 'Sie können das HTML dieser Spalte mit dem oben angegebenen Textfeld anpassen.';
$string['footercolumn2heading'] = 'Inhalt des Footers für die 2. Spalte (Mitte)';
$string['footercolumn2headingdesc'] = 'Dieser Abschnitt bezieht sich auf den unteren Teil (Spalte 2) Ihrer Startseite.';
$string['footercolumn2title'] = 'Titel der 2. Footer-Spalte';
$string['footercolumn2titledesc'] = 'Fügen Sie einen Titel zu dieser Spalte hinzu.';
$string['footercolumn2customhtml'] = 'Benutzerdefiniertes HTML';
$string['footercolumn2customhtmldesc'] = 'Sie können das HTML dieser Spalte mit dem oben angegebenen Textfeld anpassen.';
$string['footercolumn3heading'] = 'Inhalt des Footers für die 3. Spalte (Mitte)';
$string['footercolumn3headingdesc'] = 'Dieser Abschnitt bezieht sich auf den unteren Teil (Spalte 3) Ihrer Startseite.';
$string['footercolumn3title'] = 'Titel der 3. Footer-Spalte';
$string['footercolumn3titledesc'] = 'Fügen Sie einen Titel zu dieser Spalte hinzu.';
$string['footercolumn3customhtml'] = 'Benutzerdefiniertes HTML';
$string['footercolumn3customhtmldesc'] = 'Sie können das HTML dieser Spalte mit dem oben angegebenen Textfeld anpassen.';
$string['footercolumn4heading'] = 'Inhalt des Footers für die 4. Spalte (rechts)';
$string['footercolumn4headingdesc'] = 'Dieser Abschnitt bezieht sich auf den unteren Teil (Spalte 4) Ihrer Startseite.';
$string['footercolumn4title'] = 'Titel der 4. Footer-Spalte';
$string['footercolumn4titledesc'] = 'Fügen Sie einen Titel zu dieser Spalte hinzu.';
$string['footercolumn4customhtml'] = 'Benutzerdefiniertes HTML';
$string['footercolumn4customhtmldesc'] = 'Sie können das HTML dieser Spalte mit dem oben angegebenen Textfeld anpassen.';
$string['footerbottomheading'] = 'Einstellungen für den unteren Footer';
$string['footerbottomdesc'] = 'Hier können Sie Ihren eigenen Link angeben, den Sie im unteren Bereich des Footers eingeben möchten.';
$string['footerbottomtextdesc'] = 'Fügen Sie Text zur Einstellung des unteren Footers hinzu.';
$string['footercopyrightsshow'] = 'anzeigen';
$string['footercopyright'] = 'Urheberrechtsinhalt anzeigen';
$string['footercopyrights'] = '[site] © [year]. Alle Rechte vorbehalten.';
$string['footercopyrightsdesc'] = 'Fügen Sie Urheberrechtsinhalte am Ende der Seite hinzu.';
$string['footercopyrightstags'] = 'Tags:<br>[site] - Website-Name<br>[year] - Aktuelles Jahr';
$string['footerbottomlink'] = 'Link im unteren linken Bereich des Fußbereichs';
$string['footerbottomlinkdesc'] = 'Geben Sie den Link für den unteren linken Bereich des Fußbereichs ein. Zum Beispiel http://www.ihrefirma.de';
$string['footerbottomtext'] = 'Text im unteren linken Bereich des Fußbereichs';
$string['footerbottomlink'] = 'Link im unteren linken Bereich des Fußbereichs';
$string['copyrighttextarea'] = 'Urheberrechtsinhalt';
$string['footercolumnsize'] = 'Anzahl von Widgets';
$string['one'] = 'Eins';
$string['two'] = 'Zwei';
$string['three'] = 'Drei';
$string['four'] = 'Vier';
$string['showsocialmediaicon'] = 'Social-Media-Icons anzeigen';
$string['footercolumntype'] = 'Typ';
$string['footercolumncustommenudesc'] = 'Fügen Sie Ihre Menüpunkte in diesem Format hinzu, zum Beispiel:<br><pre>[
{
"text": "Fügen Sie hier Ihren Text ein",
"address": "http://XYZ.abc"
},
{
"text": "Fügen Sie hier Ihren Text ein",
"address": "http://XYZ.abc"
}, ...
]</pre>
<b style="color:red;">Hinweis:</b> Um Inhalte einfach zum Footer hinzuzufügen, passen Sie den Footer-Bereich mit unserem <a href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer" onclick= location.href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer";location.reload();>Visual Personaliser</a>';
$string['gotop'] = 'Zum Seitenanfang';

$string['menu'] = 'Menü';
$string['content'] = 'Inhalt';
$string['footercolumntypedesc'] = 'Sie können den Widget-Typ für den Footer auswählen.';
$string['socialmediaicondesc'] = 'Hier werden Social-Media-Symbole angezeigt.';
$string['footercolumncustommmenu'] = 'Menüpunkte hinzufügen';
$string['follometext'] = 'Folgen Sie mir auf {$a}';
$string['footercolumndesc'] = 'Anzahl der Widgets im Footer auswählen';
$string['footershowlogo'] = 'Footer-Logo anzeigen';
$string['footershowlogodesc'] = 'Logo im sekundären Footer anzeigen.';

$string['footertermsandconditionsshow'] = 'Allgemeine Geschäftsbedingungen anzeigen';
$string['footertermsandconditions'] = 'Link zu den Allgemeinen Geschäftsbedingungen';
$string['footertermsandconditionsdesc'] = 'Sie können einen Link zur Seite mit den Allgemeinen Geschäftsbedingungen hinzufügen.';
$string['footertermsandconditionsshowdesc'] = 'Allgemeine Geschäftsbedingungen im Footer anzeigen';
$string['footerprivacypolicyshowdesc'] = 'Link zur Datenschutzrichtlinie anzeigen';

$string['footerprivacypolicyshow'] = 'Datenschutzrichtlinie anzeigen';
$string['footerprivacypolicy'] = 'Link zur Datenschutzrichtlinie';
$string['footerprivacypolicydesc'] = 'Sie können einen Link zur Seite mit der Datenschutzrichtlinie hinzufügen.';
$string['termsandconditions'] = 'Allgemeine Geschäftsbedingungen';
$string['privacypolicy'] = 'Datenschutzrichtlinie';
$string['typeamessage'] = "Geben Sie hier Ihre Nachricht ein";
$string['allcontacts'] = "Alle Kontakte";

// Profile Page.
$string['administrator'] = 'Administrator';
$string['contacts'] = 'Kontakte';
$string['blogentries'] = 'Blog-Einträge';
$string['discussions'] = 'Diskussionen';
$string['aboutme'] = 'Über mich';
$string['courses'] = 'Kurse';
$string['interests'] = 'Interessen';
$string['institution'] = 'Abteilung & Institution';
$string['location'] = 'Ort';
$string['description'] = 'Beschreibung';
$string['editprofile'] = 'Profil bearbeiten';
$string['start_date'] = 'Startdatum';
$string['complete'] = 'Vollständig';
$string['surname'] = 'Nachname';
$string['actioncouldnotbeperformed'] = 'Aktion konnte nicht ausgeführt werden!';
$string['enterfirstname'] = 'Bitte geben Sie Ihren Vornamen ein.';
$string['enterlastname'] = 'Bitte geben Sie Ihren Nachnamen ein.';
$string['entervalidphoneno'] = 'Geben Sie eine gültige Telefonnummer ein';
$string['enteremailid'] = 'Bitte geben Sie Ihre E-Mail-ID ein.';
$string['enterproperemailid'] = 'Bitte geben Sie eine korrekte E-Mail-ID ein.';
$string['detailssavedsuccessfully'] = 'Details erfolgreich gespeichert!';
$string['fullname'] = 'Vollständiger Name';
$string['viewcourselow'] = 'Kurs anzeigen';

$string['focusmodesettings'] = 'Einstellungen für den Fokus-Modus';
$string['focusmode'] = 'Fokus-Modus';
$string['enablefocusmode'] = 'Fokus-Modus aktivieren';
$string['enablefocusmodedesc'] = 'Wenn aktiviert, wird auf der Kursseite ein Button zur Umschaltung auf ein ablenkungsfreies Lernen angezeigt.';
$string['focusmodeenabled'] = 'Fokus-Modus aktiviert';
$string['focusmodedisabled'] = 'Fokus-Modus deaktiviert';
$string['coursedata'] = 'Kursdaten';
$string['prev'] = 'Zurück';
$string['next'] = 'Weiter';
$string['enablecoursestats'] = 'Kursstatistiken aktivieren';
$string['enablecoursestatsdesc'] = 'Wenn aktiviert, können Administratorinnen, Managerinnen und Lehrer*innen Statistiken von Nutzern sehen, die den Kurs besuchen, auf der Einzelkurs-Seite.';

// Course Stats.
$string['notenrolledanycourse'] = 'Nicht in einem Kurs eingeschrieben.';
$string['enrolledusers'] = 'Eingeschriebene Studierende';
$string['studentcompleted'] = 'Studierende abgeschlossen';
$string['inprogress'] = 'In Bearbeitung';
$string['yettostart'] = 'Noch nicht begonnen';
$string['completepercent'] = '{$a}% des Kurses abgeschlossen';
$string['seeallmycourses'] = "<span class='d-none d-lg-block'>Alle meine </span> <span>Kurse in Bearbeitung ansehen</span>";
$string['noactivity'] = 'Keine Aktivitäten im Kurs';
$string['activitydata'] = '{$a->complete} von {$a->total} Aktivitäten abgeschlossen';

// Login Page Strings.
$string['loginsettingpic'] = 'Hintergrundbild hochladen';
$string['loginsettingpicdesc'] = 'Laden Sie ein Bild als Hintergrund für das Anmeldeformular hoch.';
$string['loginpagelayout'] = 'Position des Anmeldeformulars';
$string['loginpagelayoutdesc'] = 'Wählen Sie das Design der Anmeldeseite aus.';
$string['logincenter'] = 'Zentriert';
$string['loginleft'] = 'Linke Seite';
$string['loginright'] = 'Rechte Seite';
$string['brandlogopos'] = "Logo auf Anmeldeseite anzeigen";
$string['brandlogoposdesc'] = "Wenn aktiviert, wird das Markenlogo auf der Anmeldeseite angezeigt.";
$string['hiddenlogo'] = "Deaktivieren";
$string['sidebarregionlogo'] = 'Auf der Anmeldeseitenkarte';
$string['maincontentregionlogo'] = 'Auf der zentralen Region';
$string['loginpanellogo'] = 'Header-Logo (Anmeldeseite)';
$string['loginpanellogodesc'] = 'Abhängig von der Einstellung <strong>Site-Logo-Format auswählen</strong>';
$string['signuptextcolor'] = 'Site-Beschreibungsfarbe';
$string['signuptextcolordesc'] = 'Wählen Sie die Textfarbe für die Site-Beschreibung aus.';
$string['brandlogotext'] = "Site-Beschreibung";
$string['loginpagesitedescription'] = 'Anmeldeseite Site-Beschreibung';
$string['brandlogotextdesc'] = "Fügen Sie Text für die Site-Beschreibung hinzu, der auf der Anmelde- und Registrierungsseite angezeigt wird. Lassen Sie dies leer, wenn Sie keine Beschreibung angeben möchten.";
$string['createnewaccount'] = 'Neues Konto erstellen';
$string['welcometobrand'] = 'Hallo, Willkommen bei {$a}';
$string['entertologin'] = "Geben Sie Ihre Daten ein, um sich anzumelden.";
$string['forgotaccount'] = 'Passwort vergessen?';
$string['potentialidps'] = 'Oder melden Sie sich mit Ihrem Konto an';
$string['firsttime'] = 'Erste Verwendung dieser Seite';

// Signup Page.
$string['createnewaccount'] = 'Ein neues Konto erstellen';

// Course Page Settings.
$string['coursesettings'] = "Kursseite";
$string['enrolpagesettings'] = "Einstellungen für Einschreibeseite";
$string['enrolpagesettingsdesc'] = "Verwalten Sie hier den Inhalt der Einschreibeseite.";
$string['coursearchivepagesettings'] = 'Einstellungen für den Kursarchivseite';
$string['coursearchivepagesettingsdesc'] = 'Verwalten Sie das Layout und den Inhalt der Kursarchivseite.';
$string['courseperpage'] = 'Kurse pro Seite';
$string['courseperpagedesc'] = 'Anzahl der anzuzeigenden Kurse pro Seite auf der Kursarchivseite.';
$string['none'] = 'Keine';
$string['fade'] = 'Verblassen';
$string['slide-top'] = 'Nach oben schieben';
$string['slide-bottom'] = 'Nach unten schieben';
$string['slide-right'] = 'Nach rechts schieben';
$string['scale-up'] = 'Vergrößern';
$string['scale-down'] = 'Verkleinern';
$string['courseanimation'] = 'Animation für Kurskarte';
$string['courseanimationdesc'] = 'Wählen Sie eine Kurskartenanimation aus, die auf der Kursarchivseite angezeigt werden soll.';

$string['currency'] = 'USD';
$string['currency_symbol'] = '$';
$string['enrolment_payment'] = 'Anzeige des Labels \'KOSTENLOS\' bei Kursen ohne Anmeldegebühr';
$string['enrolment_payment_desc'] = 'Diese Einstellung bestimmt, ob ein "KOSTENLOS"-Label für Kurse ohne Anmeldegebühren angezeigt wird. Wenn auf "Nein" gesetzt, wird das Label auf der Anmeldeseite nicht erscheinen.';
$string['allrequirepayment'] = 'Nein';
$string['somearefree'] = 'Ja';
$string['allarefree'] = 'Alle Kurse sind kostenlos';

$string['showcoursepricing'] = 'Kurspreise anzeigen';
$string['showcoursepricingdesc'] = 'Aktivieren Sie diese Einstellung, um den Preisabschnitt auf der Anmeldeseite anzuzeigen.';
$string['fullwidthcourseheader'] = 'Kopfzeile des Kurses in voller Breite';
$string['fullwidthcourseheaderdesc'] = 'Aktivieren Sie diese Einstellung, um die Kopfzeile des Kurses in voller Breite zu machen.';

$string['price'] = 'Preis';
$string['course_free'] = 'KOSTENLOS';
$string['enrolnow'] = '{$a} Jetzt';
$string['buyand'] = 'Kaufen & ';
$string['notags'] = 'Keine Tags.';
$string['tags'] = 'Tags';

$string['enrolment_layout'] = 'Layout der Einschreibeseite';
$string['enrolment_layout_desc'] = 'Aktivieren Sie das Edwiser-Layout für ein neues und verbessertes Design der Einschreibeseite.';
$string['disable'] = 'Deaktivieren';
$string['defaultlayout'] = 'Standard-Moodle-Layout';
$string['enable_layout1'] = 'Edwiser-Layout';

$string['webpage'] = "Webseite";
$string['categorypagelayout'] = 'Layout für den Kursarchiv-Seite';
$string['categorypagelayoutdesc'] = 'Wählen Sie zwischen den Kursarchiv-Layouts.';
$string['edwiserlayout'] = 'Edwiser-Layout';
$string['categoryfilter'] = 'Kategorie-Filter';

$string['skill1'] = 'Anfänger';
$string['skill2'] = 'Fortgeschritten';
$string['skill3'] = 'Experte';

$string['lastupdatedon'] = 'Zuletzt aktualisiert am ';

$string['courseoverview'] = "Kursübersicht";
$string['coursecontent'] = "Kursinhalt";
$string['instructors'] = "Dozenten";
$string['reviews'] = "Bewertungen";
$string['curatedby'] = 'Kursbetreuer';
$string["studentsenrolled"] = 'Eingeschriebene Studenten';
$string['lesson'] = 'Lektion';
$string['category'] = 'Kategorie';
$string['review'] = 'Bewertung';
$string['length'] = 'Dauer';
$string['lecture'] = 'Vorlesung';
$string['startdate'] = 'Startdatum';
$string['skilllevel'] = 'Kenntnisstand';
$string['language'] = 'Sprache';
$string['certificate'] = 'Zertifikat';
$string['students'] = 'Studenten';
$string['courses'] = 'Kurse';

// Course archive.
$string['cachedef_courses'] = 'Cache für Kurse';
$string['cachedef_guestcourses'] = 'Cache für Gastkurse';
$string['cachedef_updates'] = 'Cache für Aktualisierungen';
$string['mycourses'] = "Meine Kurse";
$string['allcategories'] = 'Alle Kategorien';
$string['categorysort'] = 'Kategorien sortieren';
$string['sortdefault'] = 'Sortieren (keine)';
$string['sortascending'] = 'Sortieren A bis Z';
$string['sortdescending'] = 'Sortieren Z bis A';

// Frontpage Old String.
// Home Page Settings.
$string['homepagesettings'] = 'Startseite';
$string['frontpagedesign'] = 'Design der Startseite';
$string['frontpagedesigndesc'] = 'Aktivieren Sie den Legacy-Builder oder den Edwiser RemUI-Homepage-Builder.';
$string['frontpagechooser'] = 'Wählen Sie das Design der Startseite';
$string['frontpagechooserdesc'] = 'Wählen Sie das Design Ihrer Startseite.';
$string['frontpagedesignold'] = 'Legacy Homepage Builder';
$string['frontpagedesignolddesc'] = 'Standard-Dashboard wie zuvor.';
$string['frontpagedesignnew'] = 'Neues Design';
$string['frontpagedesignnewdesc'] = 'Frisches neues Design mit mehreren Abschnitten. Sie können Abschnitte individuell auf der Startseite konfigurieren.';
$string['newhomepagedescription'] = 'Klicken Sie auf "Site Home" in der Navigationsleiste, um zum "Homepage Builder" zu gelangen und Ihre eigene Homepage zu erstellen.';
$string['frontpageloader'] = 'Ladebild für die Startseite hochladen';
$string['frontpageloaderdesc'] = 'Ersetzt den Standard-Ladebildschirm durch Ihr Bild.';
$string['frontpageimagecontent'] = 'Header-Inhalt';
$string['frontpageimagecontentdesc'] = 'Dieser Abschnitt bezieht sich auf den oberen Teil Ihrer Startseite.';
$string['frontpageimagecontentstyle'] = 'Stil';
$string['frontpageimagecontentstyledesc'] = 'Sie können zwischen statischem Inhalt und Slider wählen.';
$string['staticcontent'] = 'Statisch';
$string['slidercontent'] = 'Slider';
$string['addtext'] = 'Text hinzufügen';
$string['defaultaddtext'] = 'Bildung ist ein bewährter Weg zum Fortschritt.';
$string['addtextdesc'] = 'Hier können Sie den Text hinzufügen, der auf der Startseite angezeigt werden soll, am besten in HTML.';
$string['uploadimage'] = 'Bild hochladen';
$string['uploadimagedesc'] = 'Sie können ein Bild als Inhalt für die Folie hochladen.';
$string['video'] = 'iframe Eingebetteter Code';
$string['videodesc'] = 'Hier können Sie den iframe Eingebetteten Code des Videos einfügen, das eingebettet werden soll.';
$string['contenttype'] = 'Inhaltstyp auswählen';
$string['contentdesc'] = 'Sie können zwischen Bild oder Video-URL wählen.';
$string['imageorvideo'] = 'Bild/ Video';
$string['image'] = 'Bild';
$string['videourl'] = 'Video-URL';
$string['slideinterval'] = 'Folienintervall';
$string['slideintervalplaceholder'] = 'Positive ganze Zahl in Millisekunden.';
$string['slideintervaldesc'] = 'Sie können die Übergangszeit zwischen den Folien festlegen. Wenn es nur eine Folie gibt, hat diese Option keine Wirkung. Wenn das Intervall ungültig ist (leer | 0 | kleiner als 0), wird das Standardintervall von 5000 Millisekunden verwendet.';
$string['slidercount'] = 'Anzahl der Folien';
$string['slidercountdesc'] = '';
$string['one'] = '1';
$string['two'] = '2';
$string['three'] = '3';
$string['four'] = '4';
$string['five'] = '5';
$string['six'] = '6';
$string['eight'] = '8';
$string['nine'] = '9';
$string['twelve'] = '12';
$string['slideimage'] = 'Bilder für Slider hochladen';
$string['slideimagedesc'] = 'Sie können ein Bild als Inhalt für diese Folie hochladen.';
$string['sliderurl'] = 'Link zum Slider-Button hinzufügen';
$string['slidertext'] = 'Slider-Text hinzufügen';
$string['defaultslidertext'] = '';
$string['slidertextdesc'] = 'Sie können den Textinhalt für diese Folie einfügen. Am besten in HTML.';
$string['sliderbuttontext'] = 'Schaltflächentext auf Folie hinzufügen';
$string['sliderbuttontextdesc'] = 'Sie können Text zur Schaltfläche auf dieser Folie hinzufügen.';
$string['sliderurldesc'] = 'Sie können den Link zur Seite einfügen, auf die der Benutzer weitergeleitet wird, wenn er auf die Schaltfläche klickt.';
$string['sliderautoplay'] = 'Slider-Autoplay einstellen';
$string['sliderautoplaydesc'] = 'Wählen Sie "Ja", wenn automatische Übergänge in Ihrer Diashow gewünscht sind.';
$string['true'] = 'Ja';
$string['false'] = 'Nein';
$string['frontpageblocks'] = 'Inhalt des Hauptbereichs';
$string['frontpageblocksdesc'] = 'Sie können eine Überschrift für den Hauptbereich Ihrer Website einfügen';
$string['frontpageblockdisplay'] = 'Über Uns Abschnitt';
$string['frontpageblockdisplaydesc'] = 'Sie können den Abschnitt "Über uns" ein- oder ausblenden. Außerdem können Sie den Abschnitt "Über uns" im Gitterformat anzeigen.';
$string['donotshowaboutus'] = 'Nicht anzeigen';
$string['showaboutusinrow'] = 'Abschnitt in einer Zeile anzeigen';
$string['showaboutusingridblock'] = 'Abschnitt im Gitter-Block anzeigen';

// About Us.
$string['frontpageaboutus'] = 'Über uns auf der Startseite';
$string['frontpageaboutusdesc'] = 'Dieser Abschnitt ist für die Beschreibung von Über uns auf der Startseite';
$string['frontpageaboutustitledesc'] = 'Titel für den Abschnitt Über uns hinzufügen';
$string['frontpageaboutusbody'] = 'Beschreibung für den Abschnitt Über uns';
$string['frontpageaboutusbodydesc'] = 'Eine kurze Beschreibung für diesen Abschnitt';
$string['enablesectionbutton'] = 'Schaltflächen für Abschnitte aktivieren';
$string['enablesectionbuttondesc'] = 'Aktivieren Sie die Schaltflächen für die Abschnitte.';
$string['sectionbuttontextdesc'] = 'Geben Sie den Text für die Schaltfläche in diesem Abschnitt ein.';
$string['sectionbuttonlinkdesc'] = 'Geben Sie den URL-Link für diesen Abschnitt ein.';
$string['frontpageblocksectiondesc'] = 'Titel für diesen Abschnitt hinzufügen.';

// Block section 1.
$string['frontpageblocksection1'] = 'Titel für den 1. Abschnitt';
$string['frontpageblockdescriptionsection1'] = 'Beschreibung für den 1. Abschnitt';
$string['frontpageblockiconsection1'] = 'Font-Awesome-Icon für den 1. Abschnitt';
$string['sectionbuttontext1'] = 'Text für Schaltfläche im 1. Abschnitt';
$string['sectionbuttonlink1'] = 'URL-Link für den 1. Abschnitt';

// Block section 2.
$string['frontpageblocksection2'] = 'Titel für den 2. Abschnitt';
$string['frontpageblockdescriptionsection2'] = 'Beschreibung für den 2. Abschnitt';
$string['frontpageblockiconsection2'] = 'Font-Awesome-Icon für den 2. Abschnitt';
$string['sectionbuttontext2'] = 'Text für Schaltfläche im 2. Abschnitt';
$string['sectionbuttonlink2'] = 'URL-Link für den 2. Abschnitt';

// Block section 3.
$string['frontpageblocksection3'] = 'Titel des Textkörpers für den 3. Abschnitt';
$string['frontpageblockdescriptionsection3'] = 'Beschreibung des Textkörpers für den 3. Abschnitt';
$string['frontpageblockiconsection3'] = 'Font-Awesome-Symbol für den 3. Abschnitt';
$string['sectionbuttontext3'] = 'Schaltflächentext für den 3. Abschnitt';
$string['sectionbuttonlink3'] = 'URL-Link für den 3. Abschnitt';

// Block section 4.
$string['frontpageblocksection4'] = 'Titel des Inhalts für den 4. Abschnitt';
$string['frontpageblockdescriptionsection4'] = 'Beschreibung des Inhalts für den 4. Abschnitt';
$string['frontpageblockiconsection4'] = 'Font-Awesome Symbol für den 4. Abschnitt';
$string['sectionbuttontext4'] = 'Text für Schaltfläche im 4. Abschnitt';
$string['sectionbuttonlink4'] = 'URL-Link für den 4. Abschnitt';
$string['defaultdescriptionsection'] = 'Ganzheitliche Nutzung von Just-in-Time-Technologien durch Firmenszenarien.';
$string['frontpagetestimonial'] = 'Referenzen Startseite';
$string['frontpagetestimonialdesc'] = 'Referenzen auf der Startseite';
$string['enablefrontpageaboutus'] = 'Aktiviere Referenzabschnitt';
$string['enablefrontpageaboutusdesc'] = 'Aktiviere den Referenzabschnitt auf der Startseite.';
$string['frontpageaboutusheading'] = 'Überschrift für Referenzabschnitt';
$string['frontpageaboutusheadingdesc'] = 'Überschrift für den Standard-Text des Abschnitts';
$string['frontpageaboutustext'] = 'Text für Referenzen';
$string['frontpageaboutustextdesc'] = 'Geben Sie den Text für die Referenzen auf der Startseite ein.';
$string['frontpageaboutusdefault'] = '<p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam.</p>';
$string['testimonialcount'] = 'Anzahl der Referenzen';
$string['testimonialcountdesc'] = 'Anzahl der Referenzen, die angezeigt werden sollen.';
$string['testimonialimage'] = 'Bild für Referenz';
$string['testimonialimagedesc'] = 'Bild der Person für die Referenz.';
$string['testimonialname'] = 'Name der Person';
$string['testimonialnamedesc'] = 'Name der Person.';
$string['testimonialdesignation'] = 'Funktion der Person';
$string['testimonialdesignationdesc'] = 'Funktion der Person.';
$string['testimonialtext'] = 'Referenztext';
$string['testimonialtextdesc'] = 'Was die Person sagt.';
$string['frontpageblockimage'] = 'Bild hochladen';
$string['frontpageblockimagedesc'] = 'Sie können ein Bild als Inhalt hochladen.';
$string['frontpageblockiconsectiondesc'] = 'Sie können jedes Symbol von dieser <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new">Liste</a> auswählen. Geben Sie einfach den Text nach "fa-" ein.';
$string['frontpageblockdescriptionsectiondesc'] = 'Eine kurze Beschreibung des Titels.';

// Course.
$string['graderreport'] = 'Notenübersicht';
$string['enroluser'] = 'Benutzer einschreiben';
$string['activityeport'] = 'Aktivitätsbericht';
$string['editcourse'] = 'Kurs bearbeiten';
$string['imageforcourse'] = 'Bild für Kurs';
// Next Previous Activity.
$string['activityprev'] = 'Vorherige Aktivität';
$string['activitynext'] = 'Nächste Aktivität';
$string['activitynextpreviousbutton'] = 'Schaltfläche "Nächste & Vorherige Aktivität" aktivieren';
$string['activitynextpreviousbuttondesc'] = 'Wenn diese Option aktiviert ist, wird auf der Einzelaktivitätsseite die Schaltfläche "Nächste & Vorherige Aktivität" angezeigt, um zwischen Aktivitäten zu wechseln.';
$string['disablenextprevious'] = 'Deaktivieren';
$string['enablenextprevious'] = 'Aktivieren';
$string['enablenextpreviouswithname'] = 'Aktivieren mit Aktivitätsname';

// Importer.
$string['importer'] = 'Importeur';
$string['importer-missing'] = 'Das Edwiser Site Importer-Plugin fehlt. Bitte besuchen Sie die Website von <a href="https://edwiser.org">Edwiser</a>, um dieses Plugin herunterzuladen.';

// Information center.
$string['informationcenter'] = 'Informationszentrum';
$string['licensenotactive'] = '<strong>Warnung!</strong> Lizenz ist nicht aktiviert, bitte <strong>aktivieren</strong> Sie die Lizenz in den RemUI-Einstellungen.';
$string['licensenotactiveadmin'] = '<strong>Warnung!</strong> Lizenz ist nicht aktiviert, bitte <strong>aktivieren</strong> Sie die Lizenz <a class="text-primary" href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#informationcenter" >hier</a>.';
$string['activatelicense'] = 'Lizenz aktivieren';
$string['deactivatelicense'] = 'Lizenz deaktivieren';
$string['renewlicense'] = 'Lizenz erneuern';
$string['deactivated'] = 'Deaktiviert';
$string['active'] = 'Aktiv';
$string['notactive'] = 'Nicht aktiv';
$string['expired'] = 'Abgelaufen';
$string['licensekey'] = 'Lizenzschlüssel';
$string['licensestatus'] = 'Lizenzstatus';
$string['no_activations_left'] = 'Limit überschritten';
$string['activationfailed'] = 'Aktivierung des Lizenzschlüssels fehlgeschlagen. Bitte versuchen Sie es später erneut.';
$string['noresponsereceived'] = 'Keine Antwort vom Server erhalten. Bitte versuchen Sie es später erneut.';
$string['licensekeydeactivated'] = 'Lizenzschlüssel ist deaktiviert.';
$string['siteinactive'] = 'Website inaktiv (Aktivieren Sie die Lizenz, um das Plugin zu aktivieren).';
$string['entervalidlicensekey'] = 'Bitte geben Sie einen gültigen Lizenzschlüssel ein.';
$string['nolicenselimitleft'] = 'Maximale Aktivierungsgrenze erreicht, keine Aktivierungen mehr übrig.';
$string['licensekeyisdisabled'] = 'Ihr Lizenzschlüssel ist deaktiviert.';
$string['licensekeyhasexpired'] = "Ihr Lizenzschlüssel ist abgelaufen. Bitte erneuern Sie ihn.";
$string['licensekeyactivated'] = "Ihr Lizenzschlüssel ist aktiviert.";
$string['entervalidlicensekey'] = "Bitte geben Sie den korrekten Lizenzschlüssel ein.";
$string['edwiserremuilicenseactivation'] = 'Edwiser RemUI Lizenzaktivierung';
$string['enterlicensekey'] = "Geben Sie den Lizenzschlüssel ein...";
$string['invalid'] = "Ungültig";

$string['courseheaderdesign'] = 'Kursseitenkopf-Design';
$string['courseheaderdesigndesc'] = 'Wählen Sie das Design des Kursseitenkopfes';
$string['default'] = 'Standard';
$string['headerdesign'] = 'Kopfzeilen-Design {$a}';
$string['sidebarcoursemenuheading'] = "Kursmenü";

// Notification.
$string['inproductnotification'] = "Benutzereinstellungen aktualisieren (In-Produkt-Benachrichtigung) - RemUI";

$string["noti_enrolandcompletion"] = 'Die modernen, professionell aussehenden Edwiser RemUI-Layouts haben dazu beigetragen, die Gesamtengagementrate Ihrer Lernenden in diesem Monat mit <b>{$a->enrolment} neuen Kursanmeldungen und {$a->completion} abgeschlossenen Kursen</b> brillant zu erhöhen.';

$string["noti_completion"] = 'Edwiser RemUI hat Ihre Engagementlevel bei den Studierenden verbessert: Sie haben insgesamt <b>{$a->completion} Kurse abgeschlossen</b> in diesem Monat.';

$string["noti_enrol"] = 'Ihr LMS-Design sieht großartig aus mit Edwiser RemUI: Sie haben in diesem Monat <b>{$a->enrolment} neue Kursanmeldungen</b> auf Ihrem Portal.';

$string["coolthankx"] = "Cool, danke!";

$string['gridview'] = 'Gitteransicht';
$string['listview'] = 'Listenansicht';
$string['summaryview'] = 'Zusammenfassungsansicht';

$string['side-top'] = "Inhalt der oberen Box";
$string['content'] = "Standardmäßig";
$string['side-bottom'] = "Inhalt der unteren Box";
$string['side-pre'] = "Rechte Seitenleiste";

$string['sitenamecolor'] = "Site-Name oder Icon-Farbe.";
$string['sitenamecolordesc'] = "Farbe für den Site-Namen und das Site-Icon, die auch auf der Login-Seite angewendet wird.";

$string['coursesenrolled'] = "Angemeldete Kurse";
$string['coursescompleted'] = "Abgeschlossene Kurse";
$string['activitiescompleted'] = "Abgeschlossene Aktivitäten";
$string['activitiesdue'] = "Fällige Aktivitäten";

// Customizer Strings
$string['customizer-migrate-notice'] = 'Farbeinstellungen wurden in den Customizer migriert. Klicken Sie bitte auf den untenstehenden Button, um den Customizer zu öffnen.';
$string['customizer-close-heading'] = 'Customizer schließen';
$string['customizer-close-description'] = 'Ungespeicherte Änderungen werden verworfen. Möchten Sie fortfahren?';
$string['reset'] = 'Zurücksetzen';
$string['resetall'] = 'Alle zurücksetzen';
$string['reset-settings'] = 'Alle Customizer-Einstellungen zurücksetzen';
$string['reset-settings-description'] = '

<div>Die Einstellungen des Customizers werden auf die Standardeinstellungen zurückgesetzt. Möchten Sie fortfahren?</div>
<div class="mt-3"><strong>Alle zurücksetzen:</strong> Alle Einstellungen werden zurückgesetzt.</div>
<div class="mt-3"><strong>Zurücksetzen:</strong> Alle Einstellungen außer den folgenden Einstellungen werden auf die Standardeinstellungen zurückgesetzt.</div>
';
$string['link'] = 'Link';
$string['customizer'] = 'Customizer';
$string['error'] = 'Fehler';
$string['resetdesc'] = 'Einstellungen auf den letzten gespeicherten Zustand oder die Standardeinstellungen zurücksetzen, wenn nichts gespeichert wurde';
$string['noaccessright'] = 'Entschuldigung! Sie haben keine Berechtigung, diese Seite zu verwenden.';
$string['font-family'] = 'Schriftart';
$string['font-family_help'] = 'Setzen Sie die Schriftart von {$a}';

$string['button-font-family'] = 'Schriftart';
$string['button-font-family_help'] = 'Setzen Sie die Schriftart des Buttentextes';

$string['font-size'] = 'Schriftgröße';
$string['font-size_help'] = 'Legen Sie die Schriftgröße von {$a} fest.';
$string['font-weight'] = 'Schriftgewicht';
$string['font-weight_help'] = 'Legen Sie das Schriftgewicht von {$a} fest. Die Eigenschaft font-weight legt fest, wie dick oder dünn Zeichen im Text angezeigt werden sollen.';
$string['line-height'] = 'Zeilenhöhe';
$string['line-height_help'] = 'Legen Sie die Zeilenhöhe von {$a} fest.';
$string['global'] = 'Global';
$string['global_help'] = 'Sie können globale Einstellungen wie Farbe, Schriftart, Überschriften, Schaltflächen usw. verwalten.';
$string['site'] = 'Seite';
$string['text-color'] = 'Textfarbe';
$string['welcome-text-color'] = 'Willkommenstextfarbe';
$string['text-hover-color'] = 'Text Hover-Farbe';
$string['text-color_help'] = 'Legen Sie die Textfarbe von {$a} fest.';
$string['content-color'] = 'Inhaltsfarbe';
$string['icon-color'] = 'Symbolfarbe';
$string['icon-hover-color'] = 'Symbol Hover-Farbe';
$string['icon-color_help'] = 'Legen Sie die Symbolfarbe von {$a} fest.';
$string['link-color'] = 'Linkfarbe';
$string['link-color_help'] = 'Legen Sie die Linkfarbe von {$a} fest.';
$string['link-hover-color'] = 'Link Hover-Farbe';
$string['link-hover-color_help'] = 'Legen Sie die Link Hover-Farbe von {$a} fest.';
$string['typography'] = 'Typografie';
$string['inherit'] = 'Inherit';
$string["weight-100"] = '100';
$string["weight-200"] = '200';
$string["weight-300"] = '300';
$string["weight-400"] = '400';
$string["weight-500"] = '500';
$string["weight-600"] = '600';
$string["weight-700"] = '700';
$string["weight-800"] = '800';
$string["weight-900"] = '900';
$string['text-transform'] = 'Textumwandlung';
$string['text-transform_help'] = 'Die Eigenschaft text-transform steuert die Groß- und Kleinschreibung von Text. Legen Sie die Textumwandlung von {$a} fest.';

$string['button-text-transform'] = 'Textumwandlung';
$string['button-text-transform_help'] = 'Die Eigenschaft text-transform steuert die Groß- und Kleinschreibung von Text. Legen Sie die Textumwandlung für den Schaltflächentext fest.';

$string["default"] = 'Standard';
$string["none"] = 'Keine';
$string["capitalize"] = 'Erste Buchstaben groß';
$string["uppercase"] = 'Alle Großbuchstaben';
$string["lowercase"] = 'Alle Kleinbuchstaben';
$string['background-color'] = 'Hintergrundfarbe';
$string['background-hover-color'] = 'Hintergrund Hover-Farbe';
$string['background-color_help'] = 'Legen Sie die Hintergrundfarbe von {$a} fest.';
$string['background-hover-color'] = 'Hintergrund Hover-Farbe';
$string['background-hover-color_help'] = 'Hintergrund-Hover-Farbe von {$a} festlegen';
$string['color'] = 'Farbe';
$string['customizing'] = 'Anpassen';
$string['savesuccess'] = 'Erfolgreich gespeichert.';
$string['mobile'] = 'Mobil';
$string['tablet'] = 'Tablet';
$string['hide-customizer'] = 'Anpassung ausblenden';
$string['customcss_help'] = 'Sie können benutzerdefiniertes CSS hinzufügen. Dies wird auf allen Seiten Ihrer Website angewendet.';

// Customizer Global body.
$string['body'] = 'Körper';
$string['body-font-family_desc'] = 'Schriftfamilie für die gesamte Website festlegen. Beachten Sie, dass bei Einstellung auf Standard die Schriftart aus den RemUI-Einstellungen angewendet wird.';
$string['body-font-size_desc'] = 'Grundlegende Schriftgröße für die gesamte Website festlegen.';
$string['body-fontweight_desc'] = 'Schriftgewicht für die gesamte Website festlegen.';
$string['body-text-transform_desc'] = 'Textumwandlung für die gesamte Website festlegen.';
$string['body-lineheight_desc'] = 'Zeilenhöhe für die gesamte Website festlegen.';
$string['faviconurl_help'] = 'Favicon-URL';

// Customizer Global heading.
$string['heading'] = 'Überschrift';
$string['use-custom-color'] = 'Benutzerdefinierte Farbe verwenden';
$string['use-custom-color_help'] = 'Benutzerdefinierte Farbe für {$a} verwenden';
$string['typography-heading-all-heading'] = 'Überschriften (H1 - H6)';
$string['typography-heading-h1-heading'] = 'Überschrift 1';
$string['typography-heading-h2-heading'] = 'Überschrift 2';
$string['typography-heading-h3-heading'] = 'Überschrift 3';
$string['typography-heading-h4-heading'] = 'Überschrift 4';
$string['typography-heading-h5-heading'] = 'Überschrift 5';
$string['typography-heading-h6-heading'] = 'Überschrift 6';

// Customizer Colors.
$string['primary-color'] = 'Primärfarbe';
$string['primary-color_help'] = 'Wenden Sie die Markenprimärfarbe auf die gesamte Website an. Diese Farbe wird für die Schaltflächen, Textlinks, Hover- und aktive Kopfzeilenmenüelemente sowie für Hover- und aktive Symbole angewendet. <br><b>Hinweis:</b> Das Ändern der Primärfarbe ändert nicht die Schaltflächenfarben, wenn Sie die Schaltflächenfarben über ihre individuellen Einstellungen geändert haben (<b>Global > Buttons> Button Color Settings</b>). Setzen Sie die Schaltflächenfarben von ihren individuellen Einstellungen zurück, um die Schaltflächenänderung durch globales Ändern der Primärfarbe von hier aus zu ändern.';

$string['secondary-color'] = 'Aufstiegsfarbe';
$string['secondary-color_help'] = 'Wenden Sie die Aufstiegsfarbe auf die gesamte Website an. Diese Farbe wird auf Icons im Statistikblock auf der Dashboard-Seite, Tags auf Kurskarten und Kurskopfbannern angewendet.';

$string['page-background'] = 'Seitenhintergrund';
$string['page-background_help'] = 'Legen Sie einen benutzerdefinierten Seitenhintergrund für den Seiteninhaltsbereich fest. Sie können Farbe, Verlauf oder Bild wählen. Der Farbverlaufswinkel beträgt 100 Grad.';

$string['page-background-color'] = 'Seitenhintergrundfarbe';
$string['page-background-color_help'] = 'Setzen Sie die Hintergrundfarbe für den Seiteninhaltsbereich.';

$string['page-background-image'] = 'Seitenhintergrundbild';
$string['page-background-image_help'] = 'Setzen Sie ein Bild als Hintergrund für den Seiteninhaltsbereich.';

$string['gradient'] = 'Farbverlauf';
$string['gradient-color1'] = 'Farbverlauf Farbe 1';
$string['gradient-color1_help'] = 'Setzen Sie die erste Farbe des Farbverlaufs.';
$string['gradient-color2'] = 'Farbverlauf Farbe 2';
$string['gradient-color2_help'] = 'Setzen Sie die zweite Farbe des Farbverlaufs.';
$string['gradient-color-angle'] = 'Farbverlaufswinkel';
$string['gradient-color-angle_help'] = 'Setzen Sie den Winkel für die Farbverlaufsfarben.';

$string['page-background-imageattachment'] = 'Hintergrundbildanhang';
$string['page-background-imageattachment_help'] = 'Die Hintergrundanhangseigenschaft legt fest, ob ein Hintergrundbild mit dem Rest der Seite scrollt oder fixiert ist.';

$string['image'] = 'Bild';
$string['additional-css'] = 'Zusätzliches CSS';
$string['left-sidebar'] = 'Linke Seitenleiste';
$string['main-sidebar'] = 'Hauptseitenleiste';
$string['sidebar-links'] = 'Sidebar-Links';
$string['secondary-sidebar'] = 'Sekundäre Seitenleiste';
$string['header'] = 'Header';
$string['headertypography'] = 'Header-Typografie';
$string['headercolors'] = 'Header-Farben';
$string['menu'] = 'Menü';
$string['site-identity'] = 'Seitenidentität';
$string['primary-header'] = 'Primärer Header';
$string['color'] = 'Farbe';

// Customizer Buttons.
$string['buttons'] = 'Schaltflächen';
$string['border'] = 'Rahmen';
$string['border-width'] = 'Rahmenbreite';
$string['border-width_help'] = 'Setzen Sie die Rahmenbreite von {$a}';
$string['border-color'] = 'Rahmenfarbe';
$string['border-color_help'] = 'Setzen Sie die Rahmenfarbe von {$a}';
$string['border-hover-color'] = 'Rahmenfarbe bei Hover';
$string['border-hover-color_help'] = 'Setzen Sie die Rahmenfarbe bei Hover von {$a}';
$string['border-radius'] = 'Rahmenradius';
$string['border-radius_help'] = 'Setzen Sie den Rahmenradius von {$a}';
$string['letter-spacing'] = 'Buchstabenabstand';
$string['letter-spacing_help'] = 'Setzen Sie den Buchstabenabstand von {$a}';
$string['text'] = 'Text';
$string['padding'] = 'Innenabstand';
$string['padding-top'] = 'Innenabstand oben';
$string['padding-top_help'] = 'Setzen Sie den Innenabstand oben von {$a}';
$string['padding-right'] = 'Innenabstand rechts';
$string['padding-right_help'] = 'Setzen Sie den Innenabstand rechts von {$a}';
$string['padding-bottom'] = 'Innenabstand unten';
$string['padding-bottom_help'] = 'Setzen Sie den Innenabstand unten von {$a}';
$string['padding-left'] = 'Innenabstand links';
$string['padding-left_help'] = 'Setzen Sie den Innenabstand links von {$a}';
$string['secondary'] = 'Sekundär';
$string['colors'] = 'Farben';
$string['commonbuttonsettings'] = 'Allgemeine Einstellungen';
$string['buttonsizesettings'] = 'Schaltflächengröße';
$string['buttonsizesettingshead'] = '{$a}';
$string['commonfontsettings'] = 'Schriftart';
$string['buttoncolorsettings'] = 'Schaltflächenfarbeinstellungen';

// Customizer Header.
$string['header-background-color_help'] = 'Setze die Hintergrundfarbe des Headers. Diese wird nicht angewendet, wenn <strong>Header-Hintergrundfarbe wie Logo-Hintergrundfarbe setzen</strong> aktiviert ist.';
$string['site-logo'] = 'Seitenlogo';
$string['header-menu'] = 'Header-Menü';
$string['box-shadow-size'] = 'Schatten-Box-Größe';
$string['box-shadow-size_help'] = 'Setze die Größe der Schatten-Box für den Seitenheader';
$string['box-shadow-blur'] = 'Schatten-Box-Unschärfe';
$string['box-shadow-blur_help'] = 'Setze die Unschärfe der Schatten-Box für den Seitenheader';
$string['box-shadow-color'] = 'Schatten-Box-Farbe';
$string['box-shadow-color_help'] = 'Setze die Farbe der Schatten-Box für den Seitenheader';
$string['layout-desktop'] = 'Layout Desktop';
$string['layout-desktop_help'] = 'Setze das Layout des Headers für Desktop';
$string['layout-mobile'] = 'Layout Mobil';
$string['layout-mobile_help'] = 'Setze das Layout des Headers für Mobilgeräte';
$string['header-left'] = 'Linkes Icon rechtes Menü';
$string['header-right'] = 'Rechtes Icon linkes Menü';
$string['header-top'] = 'Oben Icon unten Menü';
$string['hover'] = 'Hover';
$string['logo'] = 'Logo';
$string['applynavbarcolor'] = 'Header-Hintergrundfarbe wie Logo-Hintergrundfarbe setzen';
$string['applynavbarcolor_help'] = 'Die Logo-Hintergrundfarbe wird auf den gesamten Header angewendet. Wenn Sie die Logo-Hintergrundfarbe ändern, ändert sich auch die Hintergrundfarbe des Headers. Sie können jedoch immer noch benutzerdefinierte Textfarben und Hover-Farben für das Header-Menü festlegen.';
$string['header-background-color-warning'] = 'Wird nicht verwendet, wenn <strong>Set site color of navbar</strong> aktiviert ist.';
$string['logosize'] = 'Erwartetes Seitenverhältnis ist 130:33 für die linke Ansicht und 140:33 für die rechte Ansicht.';
$string['logominisize'] = 'Erwartetes Seitenverhältnis ist 40:33.';
$string['sitenamewithlogo'] = 'Seitenname mit Logo (nur für obere Ansicht)';

// Customizer Sidebar.
$string['link-text'] = 'Link-Text';
$string['link-text_help'] = 'Setze die Link-Textfarbe von {$a}';
$string['link-icon'] = 'Link-Symbol';
$string['link-icon_help'] = 'Setze die Link-Symbolfarbe von {$a}';
$string['active-link-color'] = 'Farbe aktiver Links';
$string['active-link-color_help'] = 'Setze eine benutzerdefinierte Farbe für aktive Links von {$a}';
$string['active-link-background'] = 'Hintergrundfarbe aktiver Links';
$string['active-link-background_help'] = 'Setze eine benutzerdefinierte Hintergrundfarbe für aktive Links von {$a}';
$string['link-hover-background'] = 'Hintergrundfarbe bei Link-Hover';
$string['link-hover-background_help'] = 'Setze die Hintergrundfarbe bei Link-Hover auf {$a}';
$string['link-hover-text'] = 'Textfarbe bei Link-Hover';
$string['link-hover-text_help'] = 'Setze die Textfarbe bei Link-Hover von {$a}';

// Customizer Footer.
$string['footer'] = 'Fußzeile';
$string['basic'] = 'Fußzeilen-Design';
$string['socialall'] = 'Social-Media-Links';
$string['advance'] = 'Hauptbereich der Fußzeile';
$string['footercolumn'] = 'Widget';
$string['footercolumnwidgetno'] = 'Anzahl der Widgets auswählen';
$string['footercolumndesc'] = 'Anzahl der anzuzeigenden Widgets in der Fußzeile.';
$string['footercolumntype'] = 'Typ auswählen';
$string['footercolumnsettings'] = 'Footer-Spalten-Einstellungen';
$string['footercolumntypedesc'] = 'Sie können den Widget-Typ für die Fußzeile wählen.';
$string['footercolumnsocial'] = 'Social-Media-Links';
$string['footercolumnsocialdesc'] = 'Wählen Sie die Links, die angezeigt werden sollen. Drücken und halten Sie die "Strg"-Taste auf der Tastatur, um mehrere Links auszuwählen.';
$string['footercolumntitle'] = 'Titel hinzufügen';
$string['footercolumntitledesc'] = 'Titel für dieses Widget hinzufügen.';
$string['footercolumncustomhtml'] = 'Inhalt';
$string['footercolumncustomhtmldesc'] = 'Sie können den Inhalt dieses Widgets mit dem unten stehenden Editor anpassen.';
$string['both'] = 'Beide';
$string['footercolumnsize'] = 'Widget-Breite anpassen';
$string['footercolumnsizenote'] = 'Ziehen Sie die vertikale Linie, um die Widget-Größe anzupassen.';
$string['footercolumnsizedesc'] = 'Sie können die Größe jedes Widgets einzeln festlegen.';
$string['footercolumnmenu'] = 'Menü';
$string['footercolumnmenureset'] = 'Footer-Spalten-Menüs';
$string['footercolumnmenudesc'] = 'Menü verlinken';
$string['footermenu'] = 'Menü';
$string['footermenudesc'] = 'Menü in Fußzeilen-Widget hinzufügen.';
$string['customizermenuadd'] = 'Menüpunkt hinzufügen';
$string['customizermenuedit'] = 'Menüpunkt bearbeiten';
$string['customizermenumoveup'] = 'Menüpunkt nach oben verschieben';
$string['customizermenuemovedown'] = 'Menüpunkt nach unten verschieben';
$string['customizermenuedelete'] = 'Menüpunkt löschen';
$string['menutext'] = 'Text';
$string['menuaddress'] = 'Adresse';
$string['menuorientation'] = 'Menüausrichtung';
$string['menuorientationdesc'] = 'Setzen Sie die Ausrichtung des Menüs. Die Ausrichtung kann vertikal oder horizontal sein.';
$string['menuorientationvertical'] = 'Vertikal';
$string['menuorientationhorizontal'] = 'Horizontal';
$string['footerfacebook'] = 'Facebook';
$string['footertwitter'] = 'Twitter';
$string['footerlinkedin'] = 'Linkedin';
$string['footergplus'] = 'Google Plus';
$string['footeryoutube'] = 'Youtube';
$string['footerinstagram'] = 'Instagram';
$string['footerpinterest'] = 'Pinterest';
$string['footerquora'] = 'Quora';
$string['footershowlogo'] = 'Logo anzeigen';
$string['footershowlogodesc'] = 'Zeigen Sie das Logo im sekundären Footer an.';
$string['footersecondarysocial'] = 'Social-Media-Links anzeigen';
$string['footersecondarysocialdesc'] = 'Zeigen Sie Links zu Social-Media-Seiten im sekundären Footer an.';
$string['footertermsandconditionsshow'] = 'Nutzungsbedingungen anzeigen';
$string['footertermsandconditions'] = 'Link zu den Nutzungsbedingungen';
$string['footertermsandconditionsdesc'] = 'Sie können einen Link zur Seite mit den Nutzungsbedingungen hinzufügen.';
$string['footerprivacypolicyshow'] = 'Datenschutz anzeigen';
$string['footerprivacypolicy'] = 'Link zur Datenschutzrichtlinie';
$string['footerprivacypolicydesc'] = 'Sie können einen Link zur Seite mit der Datenschutzrichtlinie hinzufügen.';
$string['footercopyrightsshow'] = 'Urheberrecht anzeigen';
$string['footercopyrights'] = 'Urheberrechtsinhalte';
$string['footercopyrightsdesc'] = 'Fügen Sie Urheberrechtsinhalte am Ende der Seite hinzu.';
$string['footercopyrightstags'] = 'Tags:<br>[site] - Website-Name<br>[year] - Aktuelles Jahr';
$string['termsandconditions'] = 'Nutzungsbedingungen';
$string['privacypolicy'] = 'Datenschutzrichtlinie';
$string['footerfont'] = 'Schriftart';
$string['footerbasiccolumntitle'] = 'Spaltentitel';
$string['divider-color'] = 'Trennlinienfarbe';
$string['divider-color_help'] = 'Setzen Sie die Trennlinienfarbe von {$a}';
$string['text-hover-color'] = 'Text-Hover-Farbe';
$string['text-hover-color_help'] = 'Setzen Sie die Text-Hover-Farbe von {$a}';
$string['link-color'] = 'Linkfarbe';
$string['link-color_help'] = 'Setzen Sie die Linkfarbe von {$a}';
$string['link-hover-color'] = 'Link-Hover-Farbe';
$string['link-hover-color_help'] = 'Setzen Sie die Link-Hover-Farbe von {$a}';
$string['icon-default-color'] = 'Icon-Farbe';
$string['icon-default-color_help'] = 'Icon-Farbe von {$a}';
$string['icon-hover-color'] = 'Icon-Hover-Farbe';
$string['icon-hover-color_help'] = 'Icon-Hover-Farbe von {$a}';
$string['footerfontsize_help'] = 'Setzen Sie die Schriftgröße';
$string['footer-color-heading1'] = 'Fußzeilenfarben';
$string['footer-color-heading3'] = 'Fußzeilen-Symbole';

$string['footerfontfamily'] = 'Schriftfamilie';
$string['footerfontfamily_help'] = 'Schriftfamilie';
$string['footerfontsize'] = 'Schriftgröße';
$string['footerfontsize_help'] = 'Schriftgröße des Footers';
$string['footerfontweight'] = 'Schriftstärke';
$string['footerfontweight_help'] = 'Schriftstärke des Footers';
$string['footerfonttext-transform'] = 'Textumwandlung';
$string['footerfonttext-transform_help'] = 'Textumwandlung des Footers';
$string['footerfontlineheight'] = 'Zeilenabstand';
$string['footerfontlineheight_help'] = 'Zeilenabstand des Footers';
$string['footerfontltrspace'] = 'Buchstabenspacing';
$string['footerfontltrspace_help'] = 'Buchstabenspacing von {$a}';

$string['footer-columntitle-fontfamily'] = 'Schriftfamilie';
$string['footer-columntitle-fontfamily_help'] = 'Schriftfamilie des Fußzeilentitels';
$string['footer-columntitle-fontsize'] = 'Schriftgröße';
$string['footer-columntitle-fontsize_help'] = 'Schriftgröße des Fußzeilentitels';
$string['footer-columntitle-fontweight'] = 'Schriftstärke';
$string['footer-columntitle-fontweight_help'] = 'Schriftstärke des Fußzeilentitels';
$string['footer-columntitle-textransform'] = 'Textumwandlung';
$string['footer-columntitle-textransform_help'] = 'Textumwandlung des Fußzeilentitels';
$string['footer-columntitle-lineheight'] = 'Zeilenabstand';
$string['footer-columntitle-lineheight_help'] = 'Zeilenabstand des Fußzeilentitels';
$string['footer-columntitle-ltrspace'] = 'Buchstabenspacing';
$string['footer-columntitle-ltrspace_help'] = 'Buchstabenspacing des Fußzeilentitels';
$string['footer-columntitle-color'] = 'Farbe';
$string['footer-columntitle-color_help'] = 'Farbe des Fußzeilentitels';

$string['openinnewtab'] = 'In einem neuen Tab öffnen';
$string['useheaderlogo'] = 'Verwenden Sie dasselbe Logo aus dem Header';
$string['secondaryfooterlogo'] = 'Ein neues Logo hinzufügen';
$string['logosettings'] = 'Logo-Einstellungen';
$string['loginformsettings'] = 'Login-Formular-Einstellungen';
$string['loginpagesettings'] = 'Login-Seiten-Einstellungen';
$string['footersecondary'] = 'Fußzeile unten';
$string['footer-columns'] = 'Fußzeilen-Spalten';
$string['footer-columntitle-color_help'] = 'Textfarbe von {$a} festlegen';
$string['footer-logo-color'] = 'Symbol- oder Textfarbe auswählen';
$string['footer-logo-color_help'] = 'Symbol- oder Textfarbe auswählen';
// Customizer login.
$string['login'] = 'Anmelden';
$string['panel'] = 'Panel';
$string['page'] = 'Seite';
$string['loginbackgroundopacity'] = 'Transparenz des Hintergrund-Overlays';
$string['loginbackgroundopacity_help'] = 'Wenden Sie ein Overlay auf das Hintergrundbild der Anmeldeseite an.';
$string['loginpanelbackgroundcolor_help'] = 'Wenden Sie eine Hintergrundfarbe auf das Anmelde-Panel an.';
$string['loginpaneltextcolor_help'] = 'Wenden Sie eine Textfarbe auf das Anmelde-Panel an.';
$string['loginpanelcontentcolor_help'] = 'Wenden Sie eine Textfarbe auf den Inhalt des Anmelde-Panel an.';
$string['loginpanellinkcolor_help'] = 'Wenden Sie eine Linkfarbe auf das Anmelde-Panel an.';
$string['loginpanellinkhovercolor_help'] = 'Wenden Sie eine Link-Hoverfarbe auf das Anmelde-Panel an.';
$string['login-panel-position'] = 'Position des Anmelde-Panel';
$string['login-panel-position_help'] = 'Legen Sie die Position für das Anmelde- und Registrierungs-Panel fest.';
$string['login-page-info'] = '<p><b>Hinweis:</b> Die Anmeldeseite kann im Customizer nicht angezeigt werden, da nur ausgeloggte Benutzer sie sehen können. Sie können die Einstellung testen, indem Sie die Anmeldeseite im Inkognito-Modus speichern und öffnen.</p>';
$string['login-page-setting'] = 'Hintergrundstil der Seite';
$string['login-page-backgroundgradient1'] = 'Farbe 1 auswählen';
$string['login-page-backgroundgradient2'] = 'Farbe 2 auswählen';
$string['loginpanelbackgroundcolor'] = 'Hintergrundfarbe der Seite';
$string['loginpagebackgroundcolor'] = 'Hintergrundfarbe auswählen';
$string['loginpagebackgroundcolor_help'] = 'Legen Sie den Hintergrund der Anmeldeseite fest. Sie können Farbe, Verlauf oder Bild wählen.';
$string['login-page-background_help'] = 'Wenden Sie eine Hintergrundfarbe auf das Anmelde-Panel an.';

/*Customizer Strings*/
$string['primary'] = 'Primär';

$string['dashboardsettingdesc'] = 'Einstellungen für das Dashboard';
$string['dashboardsetting'] = 'Dashboard';
$string['dashboardpage'] = 'Dashboard-Seite';
$string['enabledashboardcoursestats'] = 'Dashboard-Kursstatistiken aktivieren';
$string['enabledashboardcoursestatsdesc'] = 'Wenn aktiviert, werden Kursstatistiken auf der Dashboard-Seite angezeigt.';

$string['customizecontrolsclose'] = "Schließen-Schaltfläche für den Anpassungsmodus";

// Quick setup customizer.
$string['quicksetup'] = 'Schnelle Einrichtung';
$string['pallet'] = 'Palette';
$string['colorpallet'] = 'Farbpaletten';
$string['currentpallet'] = 'Aktuelle Palette';
$string['currentfont'] = 'Aktuelle Schriftart';
$string['colorpalletdesc'] = 'Beschreibung der Farbpaletten';
$string['preset1'] = 'Voreinstellung 1';
$string['preset2'] = 'Voreinstellung 2';
$string['sitefavicon'] = 'Website-Favicon';

$string['themecolors'] = 'Themenfarben';
$string['brandcolors-heading'] = 'Markenfarben';
$string['border-color'] = 'Rahmenfarbe';
$string['border-hover-color'] = 'Rahmenfarbe bei Hover';
$string['smart-colors-heading'] = 'Globale Farben anwenden';
$string['smart-colors-info'] = '<p>Die globalen Farben und ihre Schattierungen/Tönungen werden auf der Website angewendet, um eine optisch ansprechende Farbkombination zu erstellen.</p><p><b>Hinweis: </b>Sie haben die Flexibilität, die Farben einzelner Elemente jederzeit durch den Besuch ihrer spezifischen Einstellungen zu personalisieren.</p>';
$string['apply'] = 'Anwenden';
$string['backgroundsettings'] = 'Hintergrund-Einstellungen';

$string['ascent-background-color'] = 'Hintergrundfarbe des Aufstiegs';
$string['ascent-background-color_help'] = 'Legen Sie die Hintergrundfarbe des Aufstiegs fest. Diese Farbe wird auf den Hintergrund der Tags auf der Website angewendet, mit Ausnahme der Tags auf den Kurskarten und dem Kurskopfzeilenbanner.';
$string['element-background-color'] = 'Element-Hintergrundfarbe';
$string['element-background-color_help'] = 'Legen Sie die Element-Hintergrundfarbe fest. Diese Farbe wird auf den Hintergrund für kleinen Text, den Hintergrund beim Hover für Dropdown-Texte, den Hintergrund der Abschnittsüberschriften, Tooltips usw. angewendet.';

$string['light-border-color'] = 'Helle Rahmenfarbe';
$string['themecolors-lightbordercolor_help'] = 'Legen Sie die helle Rahmenfarbe fest. Diese Farbe wird als Rahmen für Elemente mit weißen Hintergründen wie dem Benachrichtigungsdropdown auf der Kopfzeile, Kurskarten, Suche für Kursdropdown und auf Trennlinien in den Blockelementen usw. angewendet.';

$string['medium-border-color'] = 'Mittlere Rahmenfarbe';
$string['themecolors-mediumbordercolor_help'] = 'Legen Sie die mittlere Rahmenfarbe fest. Diese Farbe wird als Rahmen- und Trennlinienfarbe angewendet. Sie wird speziell als Rahmenfarbe für Dropdowns und Suchfelder sowie als Hintergrundfarbe für Elemente angewendet, für die die Element-Hintergrundfarbe festgelegt ist (Sie finden die Einstellung für Element-Hintergrundfarben unter <b>Themenfarben > Hintergrund-Einstellungen</b>) beispielsweise für den Hintergrund von kleinem Text, den Hintergrund von Abschnittsüberschriften, Tooltips usw.';
$string['borderssettings'] = 'Rahmen-Einstellungen';

// Quick Menu settings.
$string['enablequickmenu'] = 'Schnellmenü aktivieren';
$string['enablequickmenudesc'] = 'Schwebendes Menü für schnelleren Zugriff auf Seiten.';

// Linke Navigationsleiste.
$string['createarchivepage'] = 'Kursarchivseite erstellen';
$string['createanewcourse'] = 'Neuen Kurs erstellen';
$string['remuisettings'] = 'RemUI-Einstellungen';

$string['bodysettingslinking'] = 'Erweiterte Einstellungen verknüpfen';
$string['bodysettingslinking_help'] = 'Wenn aktiviert, werden Einstellungen von Kleiner Absatz und Kleiner Infotext mit den Körpereinstellungen verknüpft.';
$string['bodysettingslinked'] = 'Mit Körpereinstellungen verknüpft';
$string['normal-para-font'] = "Normaler Absatz";
$string['smallpara-font'] = "Kleiner Absatz";
$string['smallinfo-font'] = "Kleiner Infotext";

$string['interactiveicons'] = 'Interaktive Symbole';
$string['noninteractiveicons'] = 'Nicht interaktive Symbole';
$string['singlecolorsicon'] = "Symbol mit einer Farbe";
$string['scicon-color'] = 'Farbe';
$string['scicon-color_help'] = 'Farbe des Ein-Farben-Symbols im Ruhezustand';
$string['scicon-hover'] = 'Hover';
$string['scicon-hover_help'] = 'Farbe des Ein-Farben-Symbols im Hover-Zustand';
$string['scicon-active'] = 'Aktiv';
$string['scicon-active_help'] = 'Farbe des Ein-Farben-Symbols im Aktiv-Zustand';

$string['dualcolorsicon'] = "Symbol mit zwei Farben";
$string['dcicon-color'] = 'Farbe';
$string['dcicon-color_help'] = 'Farbe des Zwei-Farben-Symbols im Ruhezustand';
$string['dcicon-hover'] = 'Hover';
$string['dcicon-hover_help'] = 'Farbe des Zwei-Farben-Symbols im Hover-Zustand';
$string['dcicon-active'] = 'Aktiv';
$string['dcicon-active_help'] = 'Farbe des Zwei-Farben-Symbols im Aktiv-Zustand';

$string['non-interactive-color'] = 'Farbe';
$string['non-interactive-color_help'] = 'Farbe des nicht interaktiven Symbols';
$string['textlink'] = 'Textlink';

$string['header-logo-setting'] = 'Header-Logo-Einstellungen';
$string['logo-bg-color'] = 'Logo-Hintergrundfarbe';
$string['logo-bg-color_help'] = 'Legen Sie die Hintergrundfarbe des Header-Markenlogos fest.';
$string['header-design-settings'] = 'Header-Design-Einstellungen';
$string['hide-show-menu-item'] = 'Menüelement ausblenden / einblenden';
$string['hide-dashboard'] = 'Dashboard ausblenden';
$string['hide-dashboard_help'] = 'Wenn diese Option aktiviert ist, wird das Dashboard-Element im Header ausgeblendet.';
$string['hide-home'] = 'Startseite ausblenden';
$string['hide-home_help'] = 'Wenn diese Option aktiviert ist, wird das Home-Element im Header ausgeblendet.';
$string['hide-my-courses'] = 'Meine Kurse ausblenden';
$string['hide-my-courses_help'] = 'Wenn diese Option aktiviert ist, werden die Elemente Meine Kurse und die verschachtelten Kurselemente im Header ausgeblendet.';
$string['hide-site-admin'] = 'Site-Administration ausblenden';
$string['hide-site-admin_help'] = 'Wenn diese Option aktiviert ist, wird das Site-Administration-Element im Header ausgeblendet.';
$string['hide-recent-courses'] = 'Zuletzt besuchte Kurse ausblenden';
$string['hide-recent-courses_help'] = 'Wenn diese Option aktiviert ist, wird die Dropdown-Liste "Zuletzt besuchte Kurse" im Header ausgeblendet.';
$string['header-menu-element-bg-color'] = 'Hintergrundfarbe des Menüelements';
$string['header-menu-element-bg-color_help'] = 'Hintergrundfarbe des Menüelements';
$string['header-menu-divider-bg-color'] = 'Farbe des Elementtrenners';
$string['header-menu-divider-bg-color_help'] = 'Farbe des Elementtrenners';
$string['hds-iconcolor'] = 'Header-Symbolfarbe';
$string['hds-boxshadow'] = 'Header-Boxschatten';

$string['hds-menuitems'] = 'Header-Menüelemente';
$string['hds-menu-fontsize_desc'] = 'Legen Sie die Schriftgröße für die Header-Menüelemente fest';
$string['hds-menu-color'] = 'Menüelementfarbe';
$string['hds-menu-color_desc'] = 'Legen Sie die Header-Menüelementfarbe fest';
$string['hds-menu-hover-color'] = 'Menüelement-Hover-Farbe';
$string['hds-menu-hover-color_desc'] = 'Legen Sie die Hover-Farbe für das Header-Menüelement fest';
$string['hds-menu-active-color'] = 'Menüelement-Aktivfarbe';
$string['hds-menu-active-color_desc'] = 'Legen Sie die Aktivfarbe für das Header-Menüelement fest';

$string['hds-icon-color'] = 'Symbolfarben';
$string['hds-icon-color_help'] = 'Header-Menü-Symbolfarben';
$string['hds-icon-hover-color'] = 'Symbol-Hover-Farbe';
$string['hds-icon-hover-color_help'] = 'Header-Menü-Symbol-Hover-Farbe';
$string['hds-icon-active-color'] = 'Aktive Symbolfarbe';
$string['hds-icon-active-color_help'] = 'Aktive Symbolfarbe für das Header-Menü-Symbol';

$string['preset1'] = "Voreinstellung 1";
$string['preset2'] = "Voreinstellung 2";
$string['preset3'] = "Voreinstellung 3";
$string['fonts'] = "Schriftarten";
$string['show'] = "Anzeigen";
$string['hide'] = "Ausblenden";

$string['other-bg-color'] = 'Andere Hintergrundfarben';
$string['text-link-panel'] = 'Text-Link';
$string['colorpalletes'] = 'Farbpaletten';
$string['selectpallete'] = 'Palette auswählen';
$string['selectfont'] = 'Schriftart auswählen';

$string['socialiconspanel'] = "Panel für soziale Symbole";
$string['social-icons-info'] = "<p>Um die Symbole für soziale Medien am unteren Rand jeder Spalte mit Inhalten anzuzeigen, gehen Sie zu <b>Footer > Footer Hauptbereich > Widget > Wählen Sie Typ = Inhalte</b> und aktivieren Sie die Einstellung zur Anzeige von Symbolen für soziale Medien.</p>";
$string['social-icons-heading'] = "Symbole für soziale Medien";
$string["custommenulinktext"] = 'Benutzerdefinierte Menüelemente';
$string["custommenulink"] = '<h6>Benutzerdefinierte Menüelemente</h6><p> Um benutzerdefinierte Menüelemente hinzuzufügen / zu bearbeiten / zu löschen, gehen Sie zu Site-Administration > Darstellung > Thema-Einstellungen > <a href="{$a}/admin/settings.php?section=themesettings#admin-custommenuitems" target ="_blank" class="text-decoration-none">Benutzerdefinierte Menüelemente</a></p>';
$string['note'] = 'Hinweis';
$string['social-media-selection-note'] = "<p>Drücken Sie Strg, um die Medien auszuwählen / abzuwählen</p>";

$string['editmodeswitch'] = "Bearbeitungsmodus umschalten";
$string['continue'] = 'Weiter';
$string['viewcourse'] = 'Kurs ansehen';
$string['hiddencourse'] = 'Versteckter Kurs';
$string['openquickmenu'] = 'Schnellmenü öffnen';
$string['closequickmenu'] = 'Schnellmenü schließen';
$string['start'] = 'Start';

$string['readmore'] = 'Weiterlesen';
$string['readless'] = 'Weniger lesen';
$string['setting'] = 'Einstellungen';
$string['lastaccess'] = 'Letzter Zugriff';
$string['certificate'] = 'Zertifikate';
$string['badge'] = 'Abzeichen';
$string['firstname'] = 'Vorname';
$string['lastname'] = 'Nachname';
$string['badgefrom'] = 'Abzeichen von {$a}';
$string['timelinenoevenettext'] = 'Keine anstehenden Aktivitäten';
$string['description'] = 'Beschreibung';
$string['instructorcounttitle'] = "Zusätzliche Lehrer im Kurs verfügbar";

$string['personalizer'] = "Visueller Personalisierer";
$string['edwpersonalizer'] = "Visueller Personalisierer";
$string['editinpersonalizer'] = "Bearbeiten mit Personalisierer";
$string['activepersonalizer'] = "Anzeigen im Edwiser Personalisierer.";
$string['searchtotalcount'] = 'Es werden {$a} Ergebnisse angezeigt';
$string['noresutssearchmsg'] = "<h4 class ='p-p-6 text-center m-0 '>Nichts zu zeigen</h4>";
$string['globarsearchresult'] = "Globale Suchergebnisse";
$string['searchresultdesctext'] = 'Ergebnisse anzeigen für';
$string['noresultfoundmg'] = "<h4 class ='p-p-6 text-center m-0 '>Keine Ergebnisse gefunden</h4>";

$string['enrol_relatedcourses'] = 'Verwandte Kurse';
$string['enrol_latestcourses'] = 'Neueste Kurse';
$string['enrol_coursecardesc'] = 'Entdecken Sie Ihr perfektes Programm in unseren Kursen.';
$string['enrol_viewall'] = 'Alle anzeigen';

$string['showrelatedcourse'] = "Verwandte Kurse anzeigen";
$string['showrelatedcoursedesc'] = "Aktivieren Sie diese Einstellung, um die verwandten Kurse auf der Anmeldeseite anzuzeigen.";

$string['showlatestcourse'] = 'Neueste Kurse anzeigen';
$string['showlatestcoursedesc'] = 'Aktivieren Sie diese Einstellung, um den neuesten Kurs auf der Anmeldeseite anzuzeigen.';

$string['latestcoursecount'] = 'Blockanzahl der letzten Kurse';
$string['latestcoursecountdesc'] = 'Geben Sie eine Zahl für die neuesten Kurse an, die auf der Einschreibeseite angezeigt werden sollen';

$string['allcourescattext'] = 'Alle Kategorien';
$string['archivecoursecounttext'] = 'Kurse';
$string['coursecardlessonstext'] = 'Lektionen';
$string['prevsectionbuttontext'] = 'Vorheriger Abschnitt';
$string['nextsectionbuttontext'] = 'Nächster Abschnitt';

$string['eight'] = '8';
$string['twelve'] = '12';
$string['sixteen'] = '16';
$string['twenty'] = '20';

$string['resume'] = 'Fortsetzen';
$string['start'] = 'Starten';
$string['completed'] = 'Abgeschlossen';

$string['siteannouncementheading'] = 'Website-weite Ankündigung';
$string['siteannouncementheadingdesc'] = 'Aktiviere eine Website-weite Ankündigung für alle Benutzer.';
$string['seosettingsheading'] = 'SEO-Einstellungen';
$string['seosettingsheadingdesc'] = 'Optimiere die Sichtbarkeit deiner Website in Suchmaschinen.';
$string['sitecustomizationhead'] = 'Website-Anpassung';
$string['sitecustomizationheaddesc'] = 'Wähle Schriftarten, Layoutgröße für Seiten und passe das Design mit CSS an.';
$string['advancefeatureshead'] = 'Einstellungen für erweiterte Funktionen';
$string['advancefeaturesheaddesc'] = 'Verbessere dein Lernerlebnis mit erweiterten Einstellungen.';
$string['mainfooterareahead'] = 'Hauptfußzeilenbereich';
$string['mainfooterareaheaddesc'] = 'Einstellungen für den Hauptfußzeilenbereich';

// Überschrift-Gewicht-Einstellungen für erweiterte Funktionen
$string['heading-adv-setting'] = 'Schriftstärke-Einstellungen';
$string['heading-regular-fontweight'] = 'Schriftstärke normal';
$string['heading-semibold-fontweight'] = 'Schriftstärke halbfett';
$string['heading-bold-fontweight'] = 'Schriftstärke fett';
$string['heading-exbold-fontweight'] = 'Schriftstärke extrabreit';

// Usage tracking.
$string["usagedatatracker"] = "Usage data tracker";
$string['enableusagetracking'] = "Aktivieren von Usage Tracking";
$string['enableusagetrackingdesc'] = "<strong>HINWEIS ZUR NUTZUNGSVERFOLGUNG</strong>

<hr class='text-muted' />

<p>Edwiser sammelt ab sofort anonyme Daten, um Produkt Nutzungsstatistiken zu generieren.</p>

<p>Diese Informationen werden uns helfen, die Entwicklung in die richtige Richtung zu lenken und die Edwiser-Gemeinschaft gedeiht.</p>

<p>Allerdings erfassen wir während dieses Vorgangs nicht Ihre personenbezogenen Daten oder Ihre Schüler. Sie können dies über das Plugin deaktivieren, wenn Sie diesen Dienst deaktivieren möchten.</p>

<p>Eine Übersicht der erhobenen Daten finden Sie <strong><a href='https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products' target='_blank'>hier</a></strong>.</p>";


$string['profileinterestinfo'] = 'Um Interessen zu bearbeiten, gehen Sie zu Profil-Einstellungen -> Profil bearbeiten ->';
$string['profileinterest'] = 'Interessen';
$string['citytowntext'] = 'Stadt / Ort';
$string['selectcountrystring'] = 'Wählen Sie ein Land...';


$string['heading-fontweight_desc'] = 'Schriftstärke für Überschriften auf der gesamten Website festlegen.';
$string['small-para-fontweight_desc'] = 'Schriftstärke für kleine Absätze auf der gesamten Website festlegen.';
$string['small-info-fontweight_desc'] = 'Schriftstärke für kleine Informationen auf der gesamten Website festlegen.';

$string['full-width-top'] = 'Vollbreite oben';
$string['full-bottom'] = 'Vollbreite unten';

$string['homepagedepricationmodalhead'] = 'Warnung zur Veralteten Startseite';

$string['homepagedepricationmodaldesc'] = 'Der Startseiten-Builder wird bald veraltet sein.';
$string['homepageedwpagebuilderoption'] = "Verwenden Sie Edwiser Pagebuilder für die Startseite";

$string['livecustomizer'] = "Live-Anpassung";

$string['loaderimagehead'] = 'Ladebild für die Website';
$string['loaderimagedesc'] = 'Wählen Sie ein Ladebild für Ihre Website aus';

$string['region-full-bottom'] = 'Bereich mit voller Breite unten';
$string['region-full-width-top'] = 'Bereich mit voller Breite oben';

$string['homepagetransparentheadertitle'] = 'Transparenter Kopfbereich-Stil';
$string['homepagetransparentheaderdesc'] = "Machen Sie den Kopfbereich Ihrer Startseite transparent";

$string['frontpageheadercolortitle'] = 'Wählen Sie die Textfarbe des Kopfbereichs';
$string['frontpageheadercolordesc'] = "Wählen Sie die Textfarbe des Kopfbereichs";

$string['transparentheaderheader'] = 'Stil des Startseiten-Kopfbereichs';
$string['transparentheaderheaderdesc'] = 'Transparenten Kopfbereichsstil aktivieren / deaktivieren';

$string['hidehomepageelement'] = 'Startseiten-Elemente ausblenden';
$string['hidehomepageelementdesc'] = 'Content-Header, Unternavigation und Aktivitätsbereich ausblenden';

$string['hideheadercontenttitle'] = 'Content-Header ausblenden';
$string['hideheadercontentdesc'] = 'Wenn aktiviert, werden der Website-Name und die sekundäre Navigation von Moodle auf der Startseite entfernt.';

$string['hideactivitysectiontitle'] = 'Aktivitätsbereich ausblenden';
$string['hideactivitysectiondesc'] = 'Wenn aktiviert, wird der Aktivitätsbereich auf der Startseite ausgeblendet.';

$string['floataddblockbtnregionselectionmsg'] = 'Neue Blöcke werden in der aktuell sichtbaren "{$a}" Region hinzugefügt';

// Einstellungsseite-Veraltungsdesign-Strings
$string['settingpage-dep-top-above-st'] = 'Klicken Sie auf "Website-Startseite" in der Navigationsleiste, um zum "Homepage Builder" zu gelangen und Ihre eigene Startseite zu erstellen.';
$string['settingpage-dep-top-st1'] = 'Wir präsentieren Ihnen eine bessere Möglichkeit, Startseiten zu erstellen und anzupassen!';
$string['settingpage-dep-top-st2'] = 'Wir freuen uns, Ihnen den Edwiser RemUI Page Builder vorzustellen, mit dem Sie eine Homepage erstellen können. Zusätzlich gibt es eine neu gestaltete Vorlagenbibliothek mit über 30 Blockvorlagen und 7 Startseitenlayouts.';
$string['settingpage-dep-top-st3'] = '1. Aktualisieren Sie den Edwiser RemUI Page Builder auf Version v4.2.0 und höher <a href="https://edwiser.org/my-account/" target="_blank">hier</a>';

$string['settingpagedepbottomst1'] = 'Wählen Sie den Page Builder im Dropdown-Menü oben aus und gehen Sie zur Startseite, um ein neues Startseitendesign zu erstellen.';
$string['settingpagedepbottomst2'] = 'Erfahren Sie mehr';
$string['settingpagedepbottomst3'] = 'ODER';

$string['settingpagedepbottomsecondaryst1'] = 'Migrieren Sie Ihre Homepage-Builder-Inhalte automatisch zum Edwiser Page Builder.';
$string['settingpagedepbottomsecondaryst2'] = '<span class="para-semibold-1 m-0">Hinweis:</span> Die Edwiser RemUI-Page-Builder-Plugin-Version v4.2.0 und die Homepage-Builder-Plugin-Version v4.1.3 werden benötigt.';
$string['settingpagedepbottomsecondaryst3'] = 'Was wird passieren?';
$string['settingpagedepbottomsecondaryst4'] = 'Der Code und der Inhalt jeder Sektion der aktuellen Startseite werden in einen benutzerdefinierten HTML-Block im Edwiser RemUI Page Builder verschoben. Das Design und der Inhalt der Seite bleiben unverändert und Sie können es einfach auf eine "No-Code" Weise mit dem Edwiser RemUI Page Builder bearbeiten.';
$string['settingpagedepbottomsecondaryst5'] = '<span class="para-semibold-1 m-0">Hinweis:</span> Dies ist das letzte Update zum Homepage Builder. Er wurde nun in den Edwiser Page Builder integriert.';

// Veraltungsmodal-Strings
$string['homepagedepricationmodalst1'] = 'Wir präsentieren Ihnen eine bessere Möglichkeit, Startseiten zu erstellen und anzupassen!';
$string['homepagedepricationmodalst2'] = '<p class="para-regular-1 m-0">Mit diesem Update können Sie nun die Leistung des <span class="para-semibold-1">Edwiser RemUI Page Builder nutzen, der speziell für Startseiten entwickelt wurde.</span></p>';
$string['homepagedepricationmodalfeatureitem1'] = 'Verbesserter Page Builder';
$string['homepagedepricationmodalfeatureitem2'] = 'Über 30 gut gestaltete Blockvorlagen';
$string['homepagedepricationmodalfeatureitem3'] = '7 Startseitenlayouts';
$string['homepagedepricationmodalfeatureitem4'] = 'Benutzerdefinierte Designs erstellen';

$string['homepagedepricationmodalst3'] = 'Bereit für den nächsten Schritt?';
$string['homepagedepricationmodalst4'] = 'Klicken Sie unten, um zu den Einstellungen zu gelangen und Ihre vorhandene Startseite nahtlos zu migrieren';
$string['homepagedepricationmodalst5'] = 'Einstellungen';
$string['homepagedepricationmodalst6'] = 'Nicht mehr anzeigen';
$string['homepagedepricationmodalst7'] = '<span class="para-regular-2">Hinweis:</span> Nach den nächsten drei Updates wird der aktuelle Homepage Builder von Edwiser RemUI veraltet sein.';

$string['homepagedrpecationmodalst8'] = 'Der neue Edwiser RemUI-Seitenersteller ist in RemUI Pro und den oben genannten Plänen verfügbar. Wenn Sie das RemUI Starterpaket verwenden, können Sie';
$string['upgradeherelinktext'] = 'hier aktualisieren';

$string['addnewpage'] = "Neue Seite hinzufügen";

$string['edwiserfeedback'] = "Edwiser Feedback";
$string['edwiserhelp'] = "Moodle Hilfe";
$string['edwisersupport'] = "Edwiser Support";


// Kursseiten neue Einstellungen und Verbesserungszeichenfolgen
$string['courseinfocontrolhead'] = "Kursinformationssteuerung";
$string['courseinfocontroldesc'] = "Steuerung der Sichtbarkeit kursbezogener Informationen auf der gesamten Website";

$string['coursedatevisibilityhead'] = "‚Datum‘ im Kurs anzeigen";
$string['coursedatevisibilitydesc'] = "‚Datum‘ im Kurs anzeigen";

$string['hidedate'] = "Nicht anzeigen";
$string['showstartdate'] = "Startdatum anzeigen";
$string['showupdatedate'] = "‚Aktualisiert am‘-Datum anzeigen";
$string['showstartwhenend'] = "‚Startdatum‘ anzeigen, wenn das ‚Enddatum‘ festgelegt ist";


$string['enrolleduserscountvisibilityhead'] = "Zeige Informationen über ‚Eingeschriebene Studierende‘";
$string['enrolleduserscountvisibilitydesc'] = "Deaktivieren, um die Informationen über ‚Eingeschriebene Studierende‘ zu verbergen";

$string['lessonsvisiblityoncoursecardhead'] = "Zeige Informationen über ‚Lektionen‘";
$string['lessonsvisiblityoncoursecarddesc'] = "Deaktivieren, um die Informationen über ‚Lektionen‘ zu verbergen";

$string['coursecardsettingshead'] = "Kurskarte";
$string['coursecardsettingsdesc'] = "Einstellungen für die Kurskarte";

$string['headeroverlayopacityhead'] = "Ändern der Deckkraft des Überlagers";
$string['headeroverlayopacitydesc'] = "Der Standardwert ist bereits auf '100' eingestellt. Um die Deckkraft anzupassen, geben Sie bitte einen Wert zwischen 0 und 100 ein";

$string['showless'] = 'Weniger anzeigen';
$string['showmore'] = 'Mehr anzeigen';

$string['coursestarted'] = "Gestartet:";
$string['courseupdated'] = "Aktualisiert:";

$string['coursecardlessonssingletext'] = 'Lektion';
$string['coursecardsenrolledetxt'] = 'Eingeschrieben';

$string['showenrolledtexthead'] = 'Titel „Eingeschrieben“ anzeigen';
$string['showenrolledtextdesc'] = '';

$string['showenrolledtextinputhead'] = '';
$string['showenrolledtextinputdesc'] = 'Benennen Sie den Titel „Enrolled“ um. <br><strong>Maximal 8 Zeichen empfohlen</strong>';
$string['showenrolledtextinputdefaulttext'] = 'Enrolled';

$string['showlessontexthead'] = 'Titel „Lektion“ anzeigen';
$string['showlessontextdesc'] = '';

$string['showlessontextinputhead'] = '';
$string['showlessontextinputdesc'] = 'Benennen Sie den Titel „Lessons“ um. <br><strong>Maximal 8 Zeichen empfohlen</strong>';
$string['showlessontextinputdefaulttext'] = 'Lessons';

$string['editcoursetitle'] = 'Kurstitel bearbeiten';
$string['changecategory'] = 'Kategorie ändern';
$string['editreviewapproval'] = 'Überprüfungsgenehmigung bearbeiten';
$string['addchangevideo'] = 'Video hinzufügen/ändern';
$string['novideomessage'] = 'Es gibt kein Video.<br>Klicken Sie auf den obigen Link, um ein Video hinzuzufügen.';
$string['changecourseimage'] = 'Kursbild ändern';
$string['changebtntextandlink'] = 'Schaltflächentext und Link ändern';
$string['edit'] = 'Bearbeiten';
$string['viewalltext'] = 'Alle anzeigen';
$string['addremuicustomfield'] = 'RemUI-Benutzerdefiniertes Feld hinzufügen';
$string['editremuicustomfield'] = 'RemUI-Benutzerdefiniertes Feld bearbeiten';
$string['howtoaddcustomfield'] = 'Wie man „Hinzufügen und Bearbeiten“ von RemUI-Benutzerdefinierten Feldern durchführt?';
$string['changebtntext'] = 'Schaltflächentext ändern';
$string['addlink'] = 'Link hinzufügen';
$string['save'] = 'Speichern';
$string['cancel'] = 'Abbrechen';
$string['updateenrollmentmethods'] = 'Aktualisieren <span class="text-lowercase">{$a}</span> Methoden';
$string['hideenrollmentoptions'] = 'Optionen ausblenden für <span class="text-lowercase">{$a}</span>';
$string['showenrollmentoptions'] = 'Optionen anzeigen für <span class="text-lowercase">{$a}</span>';
$string['editcoursetext'] = 'Kurztext bearbeiten';
$string['editcoursecontent'] = 'Kursinhalt bearbeiten';
$string['manageinstructors'] = 'Instruktoren verwalten';
$string['message'] = 'Nachricht';
$string['email'] = 'E-Mail:';
$string['editcoursessectionsettings'] = 'Einstellungen für Kursabschnitte bearbeiten';
$string['sectionishiddenmessage'] = 'Dieser Abschnitt ist ausgeblendet.<br>Um ihn sichtbar zu machen, klicken Sie auf den obigen Link „Anmeldeoptionen anzeigen“';
$string['noreviewmessage'] = 'Derzeit gibt es keine Bewertung.<br>Um Bewertungen „Zur Genehmigung ausstehend“ anzuzeigen, klicken Sie auf den Link „Überprüfungsgenehmigung bearbeiten“.';
$string['backtothecourse'] = 'Zurück zum Kurs';
$string['viewcourseenrollmentpage'] = 'Kursseite für <span class="text-lowercase">{$a}</span> anzeigen';
$string['unenroll'] = 'Abmelden';
$string['toactivateenrollmenttext'] = 'um sich selbst für die Aktivierung des Anmeldeseiten-Links';
$string['showhidefreelabel'] = '„KOSTENLOS“-Etikett anzeigen/ausblenden';
$string['norelatedcoursemessage'] = 'Der Abschnitt „Verwandte Kurse“ ist ausgeblendet.<br>Um ihn sichtbar zu machen, klicken Sie auf den obigen Link „Einstellungen für Kursabschnitte bearbeiten“.';
$string['nolatestcoursemessage'] = 'Der Abschnitt „Neueste Kurse“ ist ausgeblendet.<br>Um ihn sichtbar zu machen, klicken Sie auf den obigen Link „Einstellungen für Kursabschnitte bearbeiten“.';
$string['showhidefreelabel'] = '„KOSTENLOS“-Etikett anzeigen/ausblenden';
$string['editpricing'] = 'Preise bearbeiten';
$string['nocontentmessage'] = 'In diesem Abschnitt gibt es keinen Inhalt.<br>Um Inhalte hinzuzufügen, klicken Sie auf den obigen Link „Kurztext bearbeiten“.';
$string['noinstructormessage'] = 'In diesem Kurs ist kein Lehrer eingeschrieben.<br>Um einen Lehrer hinzuzufügen, klicken Sie auf den obigen Link „Instruktoren verwalten“.';
$string['noinstructor'] = 'Kein Lehrer';

// Dark mode settings strings
$string['darkmodetitilestring'] = 'Dunkler Modus';
$string['lightmodetitlestring'] = 'Heller Modus';
$string['darkmodesettingshead'] = 'Einstellungen für den Dunkelmodus';
$string['darkmodesettingsheaddesc'] = 'Steuerung des Licht- und Dunkelmodus Ihrer Website';
$string['enabledarkmode'] = 'Dunkelmodus-Funktionalität aktivieren';
$string['enabledarkmodedesc'] = '';
$string['dmoption_disable'] = 'Deaktivieren';
$string['dmoption_allowonallpages'] = 'Erlauben auf allen Seiten';
$string['dmoption_excludepages'] = 'Erlauben auf allen Seiten außer diesen Seiten';
$string['dmoption_includepages'] = 'Nur auf diesen Seiten erlauben';
$string['darkmodeincludepages'] = 'Nur auf diesen Seiten einschließen';
$string['darkmodeincludepagesdesc']  = '<div><strong>Um den Dunkelmodus auf bestimmten Seiten zu verwalten, fügen Sie einfach die URL der Seite hinzu.</strong>
<pre>Beispiel:
    Um den Dunkelmodus auf einer bestimmten Kursseite zu aktivieren/deaktivieren (z. B. Kurs mit ID=2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>Um den Dunkelmodus auf einer Gruppe von Seiten zu verwalten</strong>
<pre>Beispiel:
    Um den Dunkelmodus auf allen Kursseiten zu aktivieren/deaktivieren
    <MoodleSite.com>/course/view.php%
</pre>
Für eine ausführlichere Erklärung <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">klicken Sie hier</a>.</div>';

$string['darkmodeexcludepages'] = 'Seiten ausschließen';
$string['darkmodeexcludepagesdesc']  = '<div><strong>Um den Dunkelmodus auf bestimmten Seiten zu verwalten, fügen Sie einfach die URL der Seite hinzu.</strong>
<pre>Beispiel:
    Um den Dunkelmodus auf einer bestimmten Kursseite zu aktivieren/deaktivieren (z. B. Kurs mit ID=2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>Um den Dunkelmodus auf einer Gruppe von Seiten zu verwalten</strong>
<pre>Beispiel:
    Um den Dunkelmodus auf allen Kursseiten zu aktivieren/deaktivieren
    <MoodleSite.com>/course/view.php%
</pre>
Für eine ausführlichere Erklärung <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">klicken Sie hier</a>.</div>';

$string['customizerdarkmodewarning'] = "Bitte beachten Sie, dass Änderungen im Visual Personalizer im 'Hellmodus' der Website vorgenommen werden und automatisch im 'Dunkelmodus' reflektiert werden.";
$string['customizerdarkmodedonotshowbtntext'] = 'Nicht erneut anzeigen';
$string['customizerdarkmodeok'] = 'Okay';
$string['previewswitchon'] = 'Einschalten';
$string['previewswitchoff'] = 'Ausschalten';
$string['darkmodepreview'] =  'Vorschau des Dunkelmodus';
$string['darkmodecustomizernote']='<li>In \'Visual Personalizer\' werden alle Änderungen im \'Hellmodus\' der Website vorgenommen und automatisch im \'Dunkelmodus\' reflektiert.</li>
<li>Die Einstellungen des Visual Personalizers werden während der Vorschau im Dunkelmodus deaktiviert.</li>';
$string["switchtodm"] = "Dunkelmodus";
$string["switchtolm"] = "Hellmodus";
$string["disabledmwarning"] = "Um den Visual Personalizer zu aktivieren, schalten Sie die Dunkelmodus-Vorschau AUS.";

$string["forcefullmigratemsgheading"] = "Vorstellung einer besseren Möglichkeit zum Erstellen und Anpassen von Startseiten.";
$string["migratemodalheading"] = "Vorstellung einer besseren Möglichkeit zum Erstellen und Anpassen von Startseiten.";

$string["migragetcheckboxlabel"] = "Ich verstehe die obige Warnung.";
$string["migratewarningmsg"] = 'Der alte Edwiser Startseiten-Generator wird nicht mehr unterstützt. Um sicherzustellen, dass Ihre Website auf dem neuesten Stand bleibt, müssen wir Ihre Startseite auf den neuen und verbesserten "Edwiser RemUI Page Builder" migrieren.<br><br>
        <span style="font-weight: 600; display: inline-block; margin-bottom: 8px;">Hier ist, was Sie tun müssen:</span>
        <span class="deprication-choice d-flex flex-gap-4">
            <span class="choice-1">
                {$a->clickok}<br>
                <span style="font-size: 12px; line-height: 15px;">
                    <span style="font-weight: 600; display: inline-block; margin-top: 8px;">Bitte beachten Sie:</span> Die Auswahl von "Okay" migriert Ihren aktuellen Startseiteninhalt nicht.<br>
                </span>
            </span>
            <span class="align-self-center" style="font-weight: 600;">ODER</span>
            <span class="choice-2">
                {$a->warningmsg}
            </span>
        </span><br>
        Machen Sie sich keine Sorgen, dieser Vorgang ist einfach und beeinträchtigt nicht die Funktionalität Ihrer Website.';

$string["migratewarningmsg1"] = "Klicken Sie auf <span style=\"font-weight: 600;\">'Migrieren'</span>, um Ihren vorhandenen Startseiteninhalt automatisch in den neuen Seitengenerator zu übertragen.<br>";
$string["migratewarningmsg2"] = 'Aktualisieren Sie den Edwiser Page Builder, um Ihre Startseite zu migrieren. <a href="https://edwiser.helpscoutdocs.com/article/572-how-to-migrate-current-homepage-to-the-edwiser-page-builder" target="_blank" >Siehe Anweisungen <span class="edw-icon edw-icon-Shortcut redirect-shortcut"></span></a><br>';
$string["migratewarningmsg3"] = 'Installieren Sie die neueste Version des Edwiser Page Builder von der <a href="https://edwiser.org/my-account/" target="_blank" >Edwiser Mein Konto Seite <span class="edw-icon edw-icon-Shortcut redirect-shortcut"></span></a>, um Ihre aktuelle Startseite zu migrieren.<br>';
$string["migratewarningmsg4"] = 'Der Edwiser Startseiten-Generator wird nicht mehr unterstützt. Bitte deinstallieren Sie "Edwiser Startseiten-Generator (local_remuihomepage)" von <a href="{$a}" target="_blank">hier</a>.<br><br>
<span style="font-size: 12px; line-height: 15px;">
    <span style="font-weight: 600;">Bitte beachten Sie:</span> Dieser Schritt ist optional, aber wir empfehlen ihn!
</span>';
$string["migratewarningmsg5"] = 'Aktualisieren Sie den Edwiser Page Builder und den Edwiser Startseiten-Generator auf die neueste Version, um Ihre aktuelle Startseite zu migrieren. Um die neueste Version herunterzuladen <a href="https://edwiser.org/my-account/" target="_blank" >Klicken Sie hier <span class="edw-icon edw-icon-Shortcut redirect-shortcut"></span></a><br>';

$string["clickokmigratewarningmsg"] = 'Klicken Sie auf <span style="font-weight: 600;">‘Okay’</span>, um eine Startseite mit dem RemUI-Design-Generator zu erstellen.';
$string["clickokmigratewarningmsg2"] = 'Klicken Sie auf <span style="font-weight: 600;">‘Okay’</span>, um mit dem neuen Generator neu zu beginnen und eine neue Startseite zu erstellen';

$string["migragettoastmsg1"] = "Der Edwiser RemUI Seitengenerator ist eingestellt. Um die Startseite zu migrieren ";
$string["migragettoastmsg2"] = "Der Edwiser RemUI Seitengenerator ist eingestellt.";
$string["migragettoastmsg3"] = "Der alte Seitengenerator ist eingestellt.";

$string["here"] = "hier";
$string["clickhere"] = "Klicken Sie hier";
$string["settingpagedepbottomsecondaryst2b"] = '<a href="https://edwiser.org/my-account/" target="_blank" >Klicken Sie hier</a>, um die Plugins herunterzuladen und auf die neueste Version zu aktualisieren.';
$string['settingpage-dep-top-st4'] = '1. Laden Sie den Edwiser RemUI Page Builder in der Version v4.2.0 und höher von <a href="https://edwiser.org/my-account/" target="_blank">hier</a> herunter und installieren Sie ihn.';
$string['viewcoursetitle'] = 'Kurs anzeigen';
$string['okay'] = 'Okay!';
$string['forcefulmigrate'] = 'Erzwungene Migration';

$string['moodleblocks'] = 'Moodle-Blöcke';
