<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package block_remuiblck
 * @author  2022 WisdmLabs
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$string['pluginname'] = 'Edwiser RemUI block';
$string['remuiblck']  = 'Edwiser RemUI block';
$string['remuiblck:addinstance'] = 'Add a new simple HTML block';
$string['remuiblck:myaddinstance'] = 'Add a new simple HTML block to the My Moodle page';
$string['remuiblck:viewcourseanalytics'] = 'Capability for Course Analytics block';
$string['remuiblck:viewenrolldusers'] = 'Capability for Enrolled Users block';
$string['remuiblck:viewlatestmembers'] = 'Capability for Latest Members block';
$string['blockstring'] = 'Configuration RemUI Block';
$string['noofstudents'] = 'Number of Students';

$string['mycourses']        = 'My Courses';
$string['coursestats']      = 'Course Stats';
$string['tasks']            = 'Tasks';
$string['userstats']        = 'User Stats';
$string['enrolledusers']    = 'Enrolled Users Stats';
$string['quizattempts']     = 'Quiz Attempts';
$string['courseanlytics']   = 'Course Analytics';
$string['latestmembers']    = 'Latest Members';
$string['addnotes']         = 'Add Notes';
$string['noconfig']         = 'Edwiser RemUI blocks';
$string['blckexist']        = 'Block Already Exists';
$string['scheduletask'] = 'To Do List';
$string['highestgrade'] = "HIGHEST GRADE";
$string['lowestgrade'] = "LOWEST GRADE";
$string['averagegrade'] = "AVERAGE GRADE";
$string['viewcourse'] = "VIEW COURSE";
$string['allActivities'] = "All Activities";
$string['startdate'] = "Start Date";
$string['enrolledstudents'] = "Students";
$string['progress'] = "Progress";
$string['selectcategory'] = 'Select Category';

// Teacher Dashboard Strings
$string['courseprogress']   = 'Course Progress';
$string['progress'] = "Progress";
$string['name'] = "Name";
$string['status'] = "Status";
$string['back'] = "Back";
$string['enrolleduserstats'] = 'Enrolled Users Stats';

// Course progress
$string['alwaysload'] = 'Always load progress';
$string['alwaysloaddesc'] = 'When checked course progress will be always loaded.';
$string['alwaysloadwarning'] = 'For large number of courses, progress calculation takes long time. This will affect loading time of dashboard page. Warning will disappear permanently if you continue. Continue?';
$string['loadcourseprogress'] = 'Load progress';
$string['loadcourseprogressdesc'] = 'When checked course progress will be loaded. On page refresh it will be reset.';

// Course Analytics
$string['showing'] = 'Showing';
$string['showingfromto'] = 'Showing {$a->start} to {$a->to} of {$a->total}';
$string['bars'] = 'bars';


// $string['recentsection']    = 'Recent Section';
$string['recentfeedback']   = 'Recent Feedback';
$string['recentforums']     = 'Recent Forums';
$string['norecentfeedback'] = 'No Recent Feedback !';
$string['managecourses']     = 'Manage Courses';
$string['schedultask']     = 'To Do List';

// Recent Assignments
$string['assignmentstobegraded'] = 'Assignments to be Graded';
// Recently Feedback
$string['recentfeedback'] = 'Recent Feedback';
$string['recentlyactiveforums'] = 'Recently Active Forums';
$string['nocoursecategoryfound'] = 'No Course categories found in the System.';
$string['nousersincoursecategoryfound'] = 'No enrolled users found in this Course Category.';
$string['problemwhileloadingdata'] = 'Sorry, Some problem occured while loading data.';

$string['selectacourse'] = 'Select a Course';

$string['block_width'] = 'Block Width';
$string['block_height'] = 'Block Height';
$string['block_scroll'] = 'Block Scroll';
// $string['block_height'] = 'Block Height';

$string['locked'] = 'Locked';
$string['unlocked'] = 'Unlocked';


$string['norecentforums'] = 'No Recent Forums this is french';

// Blocks strings

$string['topemptybox'] = 'Top Empty Box';
$string['leftemptybox'] = 'Left Empty Box';
$string['rightemptybox'] = 'Right Empty Box';

$string['emptyboxmsg'] = 'Drag your blocks here Empty box, and this block will not display when editing is off.';

// Course stats
$string['coursestats'] = 'Course Statistics';
$string['enrolledusers'] = 'Enrolled Users';
$string['studentcompleted'] = 'Students Completed';
$string['inprogress'] = 'In Progress';
$string['yettostart'] = 'Yet to Start';
$string['card'] = 'Card';
$string['list'] = 'List';
$string['summary'] = 'Summary';

// User stats
$string['userstats'] = 'User Statistics';
$string['lastaccesstime'] = '{$a->time} ago';
$string['numsecond'] = '{$a} sec';
$string['numminute'] = '{$a} min';
$string['numhour'] = '{$a} hour';
$string['numday'] = '{$a} day';
$string['nummonth'] = '{$a} month';
$string['numyear'] = '{$a} year';
$string['searchnameemail'] = 'Search by name or email';
$string['exportcsv'] = 'Export CSV';
$string['enrolmentdate'] = 'Enrolment Date';
$string['nostudentsenrolled'] = 'No students enrolled.';
$string['nocoursecompletion'] = 'Course completion is not enabled';

// To Do List
$string['timeline'] = 'Timeline';
$string['addtask'] = 'Add task';
$string['courseevents'] = 'Course Events';
$string['incomplete'] = 'Incomplete';
$string['due'] = 'Due';
$string['duedate'] = 'Due Date';
$string['noduedate'] = 'No due date';
$string['createtask'] = 'Create new task';
$string['edittask'] = 'Edit task';
$string['nosavebutton'] = 'No save button found';
$string['subject'] = 'Subject';
$string['missingsubject'] = 'Subject missing';
$string['summary'] = 'Summary';
$string['nosummary'] = 'No summary';
$string['selectuser'] = 'Select Users';
$string['moreassignee'] = '{$a} more';
$string['notify'] = 'Notify';
$string['next7days'] = 'Next 7 days';
$string['next30days'] = 'Next 30 days';
$string['next3months'] = 'Next 3 months';
$string['next6months'] = 'Next 6 months';
$string['tasksearch'] = 'Search by Subject or Summary';
$string['todolist'] = 'To Do List';
$string['failedtomarkcomplete'] = 'Failed to mark as complete';
$string['failedtomarkincomplete'] = 'Failed to mark as incomplete';
$string['failedtodeletetask'] = 'Failed to delete task';
$string['notasks'] = 'No tasks. Add some.';
$string['deletetask'] = 'Delete task';
$string['deletetaskmessage'] = 'Do you want to delete <strong>"{$a}"</strong> task?';
$string['taskdeleted'] = 'Task <strong>{$a}</strong> deleted successfully.';
$string['searchresultfor'] = 'Showing results for <em>{$a}</em>';

// Notification string start
$string['createsubject'] = '{$a->createdby} assigned you: {$a->subject}';
$string['createmessage'] = 'Task: {$a->subject}<br>Summary: {$a->summary}<br>Assigned to: {$a->assignedto}<br>Due: {$a->timedue}';
$string['incompletesubject'] = '{$a->user} marked {$a->subject} as incomplete.';
$string['incompletemessage'] = $string['createmessage'];
$string['completesubject'] = '{$a->user} completed {$a->subject}.';
$string['completemessage'] = '{$a->user} completed {$a->subject}<br>Summary: {$a->summary}<br>Due: {$a->timedue}<br>Completed on:{$a->completedon}';
$string['editsubject'] = '{$a->createdby} updated the task: {$a->subject}';
$string['editmessage'] = $string['createmessage'];
$string['addedsubject'] = '{$a->createdby} added you in the task: {$a->subject}';
$string['addedmessage'] = $string['createmessage'];
$string['removedsubject'] = '{$a->createdby} removed you from the task: {$a->subject}';
$string['removedmessage'] = $string['createmessage'];
// Notification stings end

// Dashboard Edwiser Remui Blocks
// Settings strings
$string['dashboardsetting'] = 'Paramètres du tableau de bord';
$string['dashboardsettingdesc'] = 'Les paramètres du tableau de bord contiendront les paramètres concernant les blocs à ajouter';
$string['courseprogressblock'] = 'Bloc de progression du cours';
$string['enrolledusersblock'] = 'Blocage des utilisateurs inscrits';
$string['quizattemptsblock'] = 'Bloc de tentatives de quiz';
$string['courseanlyticsblock'] = "'Bloc d'analyse de cours'";
$string['latestmembersblock'] = 'Blocage des derniers membres';
$string['addnotesblock'] = 'Ajouter un bloc de notes';
$string['recentfeedbackblock'] = 'Bloc de commentaires récents';
$string['recentforumsblock'] = 'Bloc des forums récents';
$string['managecoursesblock'] = 'Gérer le bloc de cours';
$string['scheduletaskblock'] = 'Bloc de liste de tâches';

$string['courseprogressblockdesc'] = 'Ce bloc est visible pour les enseignants et les créateurs de cours. Il affiche le rythme auquel les étudiants progressent dans un cours.';
$string['enrolledusersblockdesc'] = 'Ce bloc est visible pour les gestionnaires et les administrateurs. Il affiche graphiquement tous les étudiants qui se sont inscrits à un cours.';
$string['quizattemptsblockdesc'] = 'Ce bloc est visible pour les enseignants et les créateurs de cours. Il affiche un rapport graphique de toutes les tentatives et non-tentatives de quiz par les étudiants.';
$string['courseanlyticsblockdesc'] = 'Ce bloc fonctionne mieux pour les étudiants. Il affiche un rapport graphique de toutes les notes que vous avez obtenues dans les cours inscrits.';
$string['latestmembersblockdesc'] = 'Ce bloc est visible pour les enseignants, les gestionnaires et les administrateurs. Il affiche tous les étudiants qui se sont récemment inscrits au LMS.';
$string['addnotesblockdesc'] = "'Ce bloc est utile pour un enseignant ou un créateur de cours. Il leur permet d'envoyer rapidement des notes ou des instructions liées au cours aux étudiants.'";
$string['recentfeedbackblockdesc'] = 'Ce bloc est utile pour les étudiants. Ils pourraient rechercher les derniers commentaires et suggestions de leurs enseignants concernant diverses activités Moodle dont ils font partie.';
$string['recentforumsblockdesc'] = 'Ce bloc est utile pour les étudiants. Ils pourraient garder une trace de toutes les dernières mises à jour et interactions qui se produisent sur un forum auquel ils se sont abonnés.';
$string['managecoursesblockdesc'] = 'Ce bloc fonctionne mieux pour les enseignants, les créateurs de cours et les gestionnaires. Le bloc fournit des informations pertinentes liées à un cours ainsi que des liens rapides pour prendre rapidement les mesures nécessaires.';
$string['scheduletaskblockdesc'] = "'Un bloc de gestion des tâches qui fonctionne le mieux pour tous les rôles d'utilisateur. Des tâches peuvent être créées et attribuées à soi-même ainsi qu'à d'autres.'";

// Add notes
$string['addnotes'] = 'Add Notes';
$string['selectacourse'] = 'Select a Course';
$string['addsitenote'] = 'Add Site Note';
$string['addcoursenote'] = 'Add Course Note';
$string['addpersonalnote'] = 'Add Personal Note';
$string['deadlines'] = 'Deadlines';
$string['selectastudent'] = 'Select a Student';
$string['nousersenrolledincourse'] = 'There are no users enrolled in {$a} Course.';
$string['selectcoursetodisplayusers'] = 'Select a Course to display its Enrolled users here.';

// Enrolled users stats
$string['enrolleduserstats'] = 'Enrolled Users Stats';
$string['problemwhileloadingdata'] = 'Sorry, Some problem occured while loading data.';
$string['nocoursecategoryfound'] = 'No Course categories found in the System.';
$string['nousersincoursecategoryfound'] = 'No enrolled users found in this Course Category.';

// Latest Members
$string['latestmembers'] = 'Latest Members';
$string['viewallusers'] = 'View All Users';
$string['userimage'] = 'User Image';

// Quiz stats
$string['quizstats'] = 'Quiz Attempt';
$string['totalusersattemptedquiz'] = 'Total Users attempted Quiz';
$string['totalusersnotattemptedquiz'] = 'Total Users not attempted Quiz';

$string['lastattempt'] = 'Last Attempt';
$string['globalattempt'] = 'Global Average';
$string['enrolledstudentdata'] = "Enrolled Students Data";
$string['search'] = 'Chercher';
$string['datatableinfo'] = "Affichage _START_ à _END_ sur _TOTAL_ entrées"; // Ne modifiez pas le  "_START_ à _END_ sur _TOTAL_" texte de cette chaîne;

$string['lastpostdate'] = 'Date';
