<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package block_remuiblck
 * @author  2022 WisdmLabs
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$string['pluginname'] = 'Edwiser RemUI Blocks';
$string['remuiblck']  = 'Edwiser RemUI Blocks';
$string['remuiblck:addinstance'] = 'Add a new simple HTML block';
$string['remuiblck:myaddinstance'] = 'Add a new simple HTML block to the My Moodle page';
$string['remuiblck:viewcourseanalytics'] = 'Capability for Course Analytics block';
$string['remuiblck:viewenrolldusers'] = 'Capability for Enrolled Users block';
$string['remuiblck:viewlatestmembers'] = 'Capability for Latest Members block';
$string['blockstring'] = 'Configuration RemUI Block';
$string['noofstudents'] = 'Number of Students';

$string['mycourses']        = 'My Courses';
$string['coursestats']      = 'Course Stats';
$string['tasks']            = 'Tasks';
$string['userstats']        = 'User Stats';
$string['enrolledusers']    = 'Enrolled Users Stats';
$string['quizattempts']     = 'Quiz Attempts';
$string['courseanlytics']   = 'Course Analytics';
$string['latestmembers']    = 'Latest Members';
$string['addnotes']         = 'Add Note';
$string['noconfig']         = 'Edwiser RemUI blocks';
$string['blckexist']        = 'Block Already Exists';
$string['scheduletask'] = 'To Do List';
$string['highestgrade'] = "Highest Grade";
$string['lowestgrade'] = "Lowest Grade";
$string['averagegrade'] = "Average Grade";
$string['viewcourse'] = "View Course";
$string['allActivities'] = "All Activities";
$string['startdate'] = "Start Date";
$string['enrolledstudents'] = "Students";
$string['progress'] = "Progress";
$string['selectcategory'] = 'Select Category';

// Teacher Dashboard Strings
$string['courseprogress']   = 'Course Progress';
$string['progress'] = "Progress";
$string['name'] = "Name";
$string['status'] = "Status";
$string['back'] = "Back";
$string['enrolleduserstats'] = 'Enrolled Users Stats';

// Course progress
$string['alwaysload'] = 'Always load progress';
$string['alwaysloaddesc'] = 'When checked course progress will be always loaded.';
$string['alwaysloadwarning'] = 'For large number of courses, progress calculation takes long time. This will affect loading time of dashboard page. Warning will disappear permanently if you continue. Continue?';
$string['loadcourseprogress'] = 'Load progress';
$string['loadcourseprogressdesc'] = 'When checked course progress will be loaded. On page refresh it will be reset.';

// Course Analytics
$string['showing'] = 'Showing';
$string['showingfromto'] = 'Showing {$a->start} to {$a->to} of {$a->total}';
$string['bars'] = 'bars';


// $string['recentsection']    = 'Recent Section';
$string['recentfeedback']   = 'Recent Feedback';
$string['recentforums']     = 'Recent Forums';
$string['norecentfeedback'] = 'No Recent Feedback !';
$string['managecourses']     = 'Manage Courses';
$string['schedultask']     = 'To Do List';

// Recent Assignments
$string['assignmentstobegraded'] = 'Assignments to be Graded';
// Recently Feedback
$string['recentfeedback'] = 'Recent Feedback';
$string['recentlyactiveforums'] = 'Recently Active Forums';
$string['nocoursecategoryfound'] = 'No Course categories found in the System.';
$string['nousersincoursecategoryfound'] = 'No enrolled users found in this Course Category.';
$string['problemwhileloadingdata'] = 'Sorry, Some problem occured while loading data.';

$string['selectacourse'] = 'Select a Course';

$string['block_width'] = 'Block Width';
$string['block_height'] = 'Block Height';
$string['block_scroll'] = 'Block Scroll';
// $string['block_height'] = 'Block Height';

$string['locked'] = 'Locked';
$string['unlocked'] = 'Unlocked';


$string['norecentforums'] = 'No Recent Forums';

// Blocks strings

$string['topemptybox'] = 'Top Empty Box';
$string['leftemptybox'] = 'Left Empty Box';
$string['rightemptybox'] = 'Right Empty Box';

$string['emptyboxmsg'] = 'Drag your blocks here Empty box, and this block will not display when editing is off.';

// Course stats
$string['coursestats'] = 'Course Statistics';
$string['enrolledusers'] = 'Enrolled Users';
$string['studentcompleted'] = 'Students Completed';
$string['inprogress'] = 'In Progress';
$string['yettostart'] = 'Yet to Start';
$string['card'] = 'Card';
$string['list'] = 'List';
$string['summary'] = 'Summary';

// User stats
$string['userstats'] = 'User Statistics';
$string['lastaccesstime'] = '{$a->time} ago';
$string['numsecond'] = '{$a} sec';
$string['numminute'] = '{$a} min';
$string['numhour'] = '{$a} hour';
$string['numday'] = '{$a} day';
$string['nummonth'] = '{$a} month';
$string['numyear'] = '{$a} year';
$string['searchnameemail'] = 'Search by name or email';
$string['exportcsv'] = 'Export CSV';
$string['enrolmentdate'] = 'Enrolment Date';
$string['nostudentsenrolled'] = 'No students enrolled.';
$string['nocoursecompletion'] = 'Course completion is not enabled';

// To Do List
$string['timeline'] = 'Timeline';
$string['addtask'] = 'Add task';
$string['courseevents'] = 'Course Events';
$string['incomplete'] = 'Incomplete';
$string['due'] = 'Due';
$string['duedate'] = 'Due Date';
$string['noduedate'] = 'No due date';
$string['createtask'] = 'Create new task';
$string['edittask'] = 'Edit task';
$string['nosavebutton'] = 'No save button found';
$string['subject'] = 'Subject';
$string['missingsubject'] = 'Subject missing';
$string['summary'] = 'Summary';
$string['nosummary'] = 'No summary';
$string['selectuser'] = 'Select Users';
$string['moreassignee'] = '{$a} more';
$string['notify'] = 'Notify';
$string['next7days'] = 'Next 7 days';
$string['next30days'] = 'Next 30 days';
$string['next3months'] = 'Next 3 months';
$string['next6months'] = 'Next 6 months';
$string['tasksearch'] = 'Search by Subject or Summary';
$string['todolist'] = 'To Do List';
$string['failedtomarkcomplete'] = 'Failed to mark as complete';
$string['failedtomarkincomplete'] = 'Failed to mark as incomplete';
$string['failedtodeletetask'] = 'Failed to delete task';
$string['notasks'] = 'There’s no to-do available.';
$string['deletetask'] = 'Delete task';
$string['deletetaskmessage'] = 'Do you want to delete <strong>"{$a}"</strong> task?';
$string['taskdeleted'] = 'Task <strong>{$a}</strong> deleted successfully.';
$string['searchresultfor'] = 'Showing results for <em>{$a}</em>';

// Notification string start
$string['createsubject'] = '{$a->createdby} assigned you: {$a->subject}';
$string['createmessage'] = 'Task: {$a->subject}<br>Summary: {$a->summary}<br>Assigned to: {$a->assignedto}<br>Due: {$a->timedue}';
$string['incompletesubject'] = '{$a->user} marked {$a->subject} as incomplete.';
$string['incompletemessage'] = $string['createmessage'];
$string['completesubject'] = '{$a->user} completed {$a->subject}.';
$string['completemessage'] = '{$a->user} completed {$a->subject}<br>Summary: {$a->summary}<br>Due: {$a->timedue}<br>Completed on:{$a->completedon}';
$string['editsubject'] = '{$a->createdby} updated the task: {$a->subject}';
$string['editmessage'] = $string['createmessage'];
$string['addedsubject'] = '{$a->createdby} added you in the task: {$a->subject}';
$string['addedmessage'] = $string['createmessage'];
$string['removedsubject'] = '{$a->createdby} removed you from the task: {$a->subject}';
$string['removedmessage'] = $string['createmessage'];
// Notification stings end

// Dashboard Edwiser Remui Blocks
// Settings strings
$string['dashboardsetting'] = 'Edwiser Remui Block Settings';
$string['dashboardsettingdesc'] = 'Edwiser Remui Block Settings will have the settings about the blocks to be added';
$string['courseprogressblock'] = 'Course Progress Block';
$string['enrolledusersblock'] = 'Enrolled Users Block';
$string['quizattemptsblock'] = 'Quiz Attempts Block';
$string['courseanlyticsblock'] = 'Course Analytics Block';
$string['latestmembersblock'] = 'Latest Members Block';
$string['addnotesblock'] = 'Add Notes Block';
$string['recentfeedbackblock'] = 'Recent Feedback Block';
$string['recentforumsblock'] = 'Recent Forums Block';
$string['managecoursesblock'] = 'Manage Course Block';
$string['scheduletaskblock'] = 'To Do List Block';

$string['courseprogressblockdesc'] = 'This block is visible to Teachers & Course Creators. It displays the pace at which students are progressing in a course.';
$string['enrolledusersblockdesc'] = 'This block is visible to Managers & Admins. It graphically displays all the students who have registered in a course.';
$string['quizattemptsblockdesc'] = 'This block is visible to Teachers & Course Creators. It displays a graphical report of all the quiz attempts and non-attempts by students.';
$string['courseanlyticsblockdesc'] = 'This block works best for Students. It displays a graphical report of all the grades that you have earned in enrolled courses.
';
$string['latestmembersblockdesc'] = 'This block is visible to Teachers, Managers & Admins. It displays all the students who recently registered to the LMS.';
$string['addnotesblockdesc'] = 'This block is useful for a Teacher or Course Creator. It lets them send course related Notes or instructions to Students quickly.';
$string['recentfeedbackblockdesc'] = 'This block is useful for Students. They could look for latest comments and suggestion from their teachers related to various Moodle activities that they are part of.';
$string['recentforumsblockdesc'] = 'This block is useful for Students. They could keep track of all the latest updates and interactions that happens on a forum in which they have subscribed.';
$string['managecoursesblockdesc'] = 'This block works best for Teachers, Course Creators & Managers. The block provides relevant information related to a course along with quick links to take necessary actions quickly.';
$string['scheduletaskblockdesc'] = 'A Task Management block that works best for all user roles. Tasks could be created and assigned to self as well as others.';

// Add notes
$string['addnotes'] = 'Add Notes';
$string['selectacourse'] = 'Select Course';
$string['addsitenote'] = 'Add Site Note';
$string['addcoursenote'] = 'Add Course Note';
$string['addpersonalnote'] = 'Add Personal Note';
$string['deadlines'] = 'Deadlines';
$string['selectastudent'] = 'Select Student';
$string['nousersenrolledincourse'] = 'There are no users enrolled in {$a} Course.';
$string['selectcoursetodisplayusers'] = 'Select a Course to display its Enrolled users here.';

// Enrolled users stats
$string['enrolleduserstats'] = 'Enrolled Users Stats';
$string['problemwhileloadingdata'] = 'Sorry, Some problem occured while loading data.';
$string['nocoursecategoryfound'] = 'No Course categories found in the System.';
$string['nousersincoursecategoryfound'] = 'No enrolled users found in this Course Category.';

// Latest Members
$string['latestmembers'] = 'Latest Members';
$string['viewallusers'] = 'View all members';
$string['userimage'] = 'User Image';

// Quiz stats
$string['quizstats'] = 'Quiz Attempt';
$string['totalusersattemptedquiz'] = 'Total Users attempted Quiz';
$string['totalusersnotattemptedquiz'] = 'Total Users not attempted Quiz';

$string['lastattempt'] = 'Last Attempt';
$string['globalattempt'] = 'Global Average';
$string['enrolledstudentdata'] = "Enrolled Students Data";
$string['search'] = 'Search';
$string['searchforcourses'] = 'Search For Courses';
$string['datatableinfo'] = "Showing _START_ to _END_ of _TOTAL_ entries"; // Do not change "_START_ to _END_ of _TOTAL_" text in this string;
$string['showentries'] = 'Show {$a->count} entries';

$string['lastpostdate'] = 'Date';
$string['grade'] = 'Grade';
